'use strict';

/* global feature:false */
define('bitbucket/internal/widget/list-branches-help-dialog', ['@atlassian/aui'], function (AJS) {
    return {
        showFor: function showFor(commitId) {
            var dialog = AJS.dialog2(aui.dialog.dialog2({
                id: 'list-branches-dialog',
                content: bitbucketPluginBranch.internal.feature.branch.branchInfo.widget.listBranchHelpDialog.listBranchesHelp({
                    commitId: commitId
                }),
                // Pre lint rule, preserved for backwards-compatibility with language packs
                // eslint-disable-next-line atlassian-wrm-i18n/i18n-key-starts-with-a-project-prefix
                titleText: AJS.I18n.getText('feature.stash.branchInfo.commit.help.header'),
                removeOnHide: true,
                footerActionContent: aui.buttons.button({
                    text: AJS.I18n.getText('bitbucket.web.button.close'),
                    type: 'link',
                    extraClasses: 'close-button'
                })
            }));
            dialog.$el.on('click', '.close-button', function () {
                return dialog.hide();
            });
            dialog.show();
        }
    };
});