define('bitbucket-plugin-branch/internal/feature/branch/branch-model/page/settings/branch-model-settings-page', ['exports', '@atlassian/aui', 'jquery', 'lodash', 'bitbucket/internal/enums', 'bitbucket/internal/feature/enforce-project-settings/enforce-project-settings', 'bitbucket/internal/feature/repository/branch-selector/branch-selector', 'bitbucket/internal/feature/repository/inherit-settings-toggle/inherit-settings-toggle', 'bitbucket/internal/model/repository', 'bitbucket/internal/model/revision-reference', 'bitbucket/internal/util/enforce-project-settings/util', 'bitbucket/internal/widget/are-you-sure/are-you-sure'], function (exports, _aui, _jquery, _lodash, _enums, _enforceProjectSettings, _branchSelector, _inheritSettingsToggle, _repository, _revisionReference, _util, _areYouSure) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.onReady = onReady;

    var _jquery2 = _interopRequireDefault(_jquery);

    var _branchSelector2 = _interopRequireDefault(_branchSelector);

    var _inheritSettingsToggle2 = _interopRequireDefault(_inheritSettingsToggle);

    var _repository2 = _interopRequireDefault(_repository);

    var _revisionReference2 = _interopRequireDefault(_revisionReference);

    var _areYouSure2 = _interopRequireDefault(_areYouSure);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    var defaultBranchId = '/USE_DEFAULT/';
    var getElById = document.getElementById.bind(document);
    var SignificantBranchTypes = {
        NONE: 'NONE',
        DEFAULT: 'DEFAULT',
        BRANCH_NAME: 'BRANCH_NAME'
    };

    function getRefForRefId(refId) {
        if (!refId) {
            return null;
        }

        if (refId === defaultBranchId) {
            return new _revisionReference2.default({
                id: defaultBranchId,
                displayId: _aui.I18n.getText('bitbucket.branchmodel.web.defaultBranch'),
                type: _revisionReference2.default.type.BRANCH
            });
        }

        return _revisionReference2.default.hydrateRefFromId(refId);
    }

    function getSelectorForType(type, repository) {
        var $trigger = (0, _jquery2.default)('#branch-model-' + type);
        var $field = (0, _jquery2.default)('#branch-model-' + type + '-field');
        var branchSelector = new _branchSelector2.default($trigger, {
            id: 'branch-model-' + type + '-dialog',
            repository: repository,
            field: $field
        });

        var lastUserRefId = void 0;

        var setLastUserRef = function setLastUserRef(refId) {
            if (refId && refId !== defaultBranchId) {
                lastUserRefId = refId;
            }
        };

        setLastUserRef($field.val()); //initialise the last user ref

        $field.change(function (_ref) {
            var originalEvent = _ref.originalEvent,
                target = _ref.target;

            var newRefId = target.value;
            var lozengeClass = 'significant-branch-lozenge';

            if (originalEvent) {
                // Keep branch selector in sync with changes made by the user to the text field
                // Only update for user `change` events (not those triggered by the BranchSelector) to prevent infinite loop
                wrapper.setBranch(newRefId);
            }

            //Because we can't have a lozenge with an empty ref, the solution is to always remove it, and sometimes replace it
            //Otherwise we could just use $.replaceWith()
            $field.next('.' + lozengeClass).remove();

            if (newRefId) {
                $field.after(bitbucket.internal.feature.repository.refLozenge.refLozenge.refLozenge({
                    ref: getRefForRefId(newRefId).toJSON(),
                    extraClasses: lozengeClass
                }));
            }

            var oldLastUserRefId = lastUserRefId;
            //Any time the field contents are changed, update the lastUserValue
            setLastUserRef(newRefId);

            //If the user selected value changes, assumedly the errors are no longer applicable
            if (oldLastUserRefId !== lastUserRefId) {
                wrapper.clearErrors();
            }
        });

        var wrapper = {
            get: function get() {
                return branchSelector.getSelectedItem();
            },
            setBranch: function setBranch(branchId) {
                if (branchId) {
                    branchSelector.setSelectedItem(getRefForRefId(branchId));
                } else {
                    this.clear();
                }
            },
            setDefaultBranch: function setDefaultBranch() {
                this.setBranch(defaultBranchId);
            },
            restorePrevious: function restorePrevious() {
                if (lastUserRefId) {
                    this.setBranch(lastUserRefId);
                } else {
                    this.clear();
                }
            },
            clear: function clear() {
                var preserveLast = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;

                if (!preserveLast) {
                    lastUserRefId = null;
                }
                branchSelector.clearSelection();
            },
            onChange: function onChange(handler) {
                $field.change(handler);
            },
            focus: function focus() {
                if ($trigger.is(':visible')) {
                    //If there is an item selected, just focus the trigger, otherwise open the picker (focuses the search box)
                    if (this.get()) {
                        $trigger.focus();
                    } else {
                        $trigger.click();
                    }
                } else {
                    $field.focus();
                }
            },
            showErrors: function showErrors(errors) {
                if (!Array.isArray(errors)) {
                    return;
                }

                errors.forEach(function (message) {
                    $field.parent('fieldset').append(aui.form.fieldError({ message: message }));
                });
            },
            clearErrors: function clearErrors() {
                $field.parent('fieldset').find('.error').remove();
            }
        };

        return wrapper;
    }

    function checkCascadingMerge(significantBranchSpecifiers) {
        var developmentEnabled = !!significantBranchSpecifiers.development.get();
        var releaseEnabled = getElById('RELEASE-enabled').checked;
        var productionEnabled = !!significantBranchSpecifiers.production.get();
        var cascadingMerge = getElById('branch-model-cascadingmerge-status');
        var cascadingMergeDisabledField = getElById('branch-model-cascadingmerge-disabled');
        var cascadingMergeCheck = getElById('branch-model-cascadingmerge-mergecheck');
        var cascadingMergeCheckDisabledField = getElById('branch-model-cascadingmerge-mergecheck-disabled');

        if (developmentEnabled && (releaseEnabled || productionEnabled)) {
            cascadingMerge.disabled = false;
        } else {
            cascadingMerge.disabled = true;
            cascadingMergeDisabledField.checked = true;
            cascadingMergeCheck.disabled = true;
            cascadingMergeCheckDisabledField.checked = true;
        }
    }

    function getBranchModelBranchType(branchModel) {
        if (branchModel) {
            if (branchModel.useDefault) {
                return SignificantBranchTypes.DEFAULT;
            }

            return SignificantBranchTypes.BRANCH_NAME;
        }

        return SignificantBranchTypes.NONE;
    }

    function resetSignificantBranch(type, branchSelector, branchModel, errors) {
        var branchModelBranchType = getBranchModelBranchType(branchModel);
        branchSelector.clear(false);

        if (branchModelBranchType === SignificantBranchTypes.BRANCH_NAME && branchModel.refId) {
            branchSelector.setBranch(branchModel.refId);
        }

        (0, _jquery2.default)('#branch-model-' + type + '-type').find('input.radio[value=' + branchModelBranchType + ']').prop('checked', true).trigger('change');

        branchSelector.showErrors(errors);
    }

    function resetCascadingMerge(branchModel, errors, isInherited) {
        var cascadingMergeDisabled = isInherited || branchModel.cascadingMergeDisabled;

        var $cascadingMerge = (0, _jquery2.default)('#branch-model-cascadingmerge-status');
        $cascadingMerge.prop('disabled', cascadingMergeDisabled).find('#branch-model-cascadingmerge-enabled').prop('checked', branchModel.cascadingMerge);

        if (branchModel.cascadingMerge) {
            var $cascadingMergeMergeCheck = (0, _jquery2.default)('#branch-model-cascadingmerge-mergecheck');
            $cascadingMergeMergeCheck.prop('disabled', !branchModel.cascadingMerge || cascadingMergeDisabled).find('#branch-model-cascadingmerge-mergecheck-enabled').prop('checked', branchModel.cascadingMergeMergeCheck);
        }

        if (Array.isArray(errors.cascadingMerge)) {
            errors.cascadingMerge.forEach(function (message) {
                $cascadingMerge.closest('fieldset').append(aui.form.fieldError({ message: message }));
            });
        }
    }

    function resetBranchModelForm(branchModel, branchSelectors) {
        var errors = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
        var isInherited = arguments[3];

        (0, _jquery2.default)('.branch-model-settings-form .error').remove();

        ['development', 'production'].forEach(function (type) {
            resetSignificantBranch(type, branchSelectors[type], branchModel[type], errors[type]);
        });

        branchModel.types.forEach(function (_ref2) {
            var id = _ref2.id,
                prefix = _ref2.prefix,
                enabled = _ref2.enabled;

            (0, _jquery2.default)('#' + id + '-enabled').prop('checked', enabled).trigger('change').nextAll('.branch-model-prefix').val(prefix || '');
        });

        resetCascadingMerge(branchModel, errors, isInherited);

        (0, _jquery2.default)('#branch-delete-source-' + (branchModel.deleteSourceBranchDefault ? 'enabled' : 'disabled')).prop('checked', true);
    }

    function getSignificantBranchFromForm(type) {
        var refId = getElById('branch-model-' + type + '-field').value;
        var useDefault = getElById('branch-model-' + type + '-type-default').checked;

        return !refId && !useDefault ? null : {
            useDefault: useDefault,
            refId: useDefault ? null : refId //To match the branch model from the server we need to use `null`, not `/USE_DEFAULT/`
        };
    }

    var getBranchModelFromForm = function getBranchModelFromForm() {
        return {
            development: getSignificantBranchFromForm('development'),
            production: getSignificantBranchFromForm('production'),
            types: (0, _lodash.map)(document.querySelectorAll('.branch-type-field'), function (el) {
                return {
                    displayName: el.querySelector('label').innerText,
                    enabled: el.querySelector('.branch-type-field-toggle').checked,
                    prefix: el.querySelector('#' + el.id + '-prefix').value,
                    id: el.id
                };
            })
        };
    };

    function hasBranchModelChanged(baseBranchModel, newBranchModel, developmentRefExists, productionRefExists) {
        baseBranchModel = _extends({}, (0, _lodash.omit)(baseBranchModel, 'scope'), { //not important for this comparison
            development: developmentRefExists ? baseBranchModel.development : { refId: null, useDefault: true },
            production: productionRefExists ? baseBranchModel.production : null
        });

        return !(0, _lodash.isEqual)(baseBranchModel, newBranchModel);
    }

    function toggleFormDisabled(toggle) {
        var formElementsSelector = ['.branch-model-settings-form fieldset:not(#inherit-settings-selection)', '#branch-model-settings-form-submit', '#branch-model-cancel'].join(',');

        (0, _lodash.forEach)(document.querySelectorAll(formElementsSelector), function (el) {
            el.disabled = toggle;
            el.setAttribute('aria-disabled', toggle);
        });
    }

    var releaseTypeEnabled = function releaseTypeEnabled(branchModel) {
        return (0, _lodash.find)(branchModel.types, { id: 'RELEASE' }).enabled;
    };

    function onReady(branchModel, _ref3, project) {
        var cascadingMerge = _ref3.cascadingMerge,
            cascadingMergeMergeCheck = _ref3.cascadingMergeMergeCheck,
            cascadingMergeDisabled = _ref3.cascadingMergeDisabled,
            developmentRefExists = _ref3.developmentRefExists,
            productionRefExists = _ref3.productionRefExists,
            repository = _ref3.repository,
            deleteSourceBranchDefault = _ref3.deleteSourceBranchDefault;

        repository = repository && new _repository2.default(repository);

        var significantBranchSelectors = {
            development: getSelectorForType('development', repository),
            production: getSelectorForType('production', repository)
        };

        (0, _enforceProjectSettings.bindEnforceSettingsSelector)();

        if ((0, _util.isRestrictionProcessing)((0, _enforceProjectSettings.getEnforceSettingsSelectorValue)())) {
            (0, _enforceProjectSettings.initiatePollTimer)({ featureKey: _util.FeatureKeys.BRANCH_MODEL, project: project });
        }

        (0, _jquery2.default)('.significant-branches input.radio').change(function (_ref4) {
            var target = _ref4.target;

            var type = target.parentNode.getAttribute('data-type');
            var branchSelector = significantBranchSelectors[type];

            (0, _jquery2.default)('#branch-model-' + type + '-field').parent().toggleClass('hidden', target.value !== SignificantBranchTypes.BRANCH_NAME);

            switch (target.value) {
                case SignificantBranchTypes.NONE:
                    branchSelector.clear();
                    break;
                case SignificantBranchTypes.DEFAULT:
                    branchSelector.setDefaultBranch();
                    break;
                case SignificantBranchTypes.BRANCH_NAME:
                    branchSelector.restorePrevious();
                    branchSelector.focus();
                    break;
            }
        });

        (0, _jquery2.default)('.branch-type-field-toggle').change(function (_ref5) {
            var target = _ref5.target;

            (0, _jquery2.default)(target).nextAll('.branch-model-prefix').prop('disabled', !target.checked).toggleClass('hidden', !target.checked);

            if (target.id === 'RELEASE-enabled') {
                checkCascadingMerge(significantBranchSelectors);
            }
        });

        significantBranchSelectors.development.onChange(function () {
            checkCascadingMerge(significantBranchSelectors);
        });

        significantBranchSelectors.production.onChange(function () {
            checkCascadingMerge(significantBranchSelectors);
        });

        (0, _jquery2.default)('#branch-model-cascadingmerge-status').change(function (_ref6) {
            var target = _ref6.target;

            var mergeCheckField = getElById('branch-model-cascadingmerge-mergecheck');

            if ('ENABLED' === target.value) {
                mergeCheckField.disabled = false;
            } else {
                getElById('branch-model-cascadingmerge-mergecheck-disabled').checked = true;
                mergeCheckField.disabled = true;
            }
        });

        (0, _jquery2.default)('#branch-model-settings-form-submit').on('click', function (e) {
            e.preventDefault();
            var $form = (0, _jquery2.default)('.branch-model-settings-form');

            if ((0, _enforceProjectSettings.isUnsavedSettingEnforced)()) {
                // confirm that restriction is being applied
                (0, _areYouSure2.default)({
                    title: _aui.I18n.getText('bitbucket.web.util.enforce.settings.warning.dialog.title'),
                    bodyContent: _aui.I18n.getText('bitbucket.branchmodel.enforce.settings.warning.dialog.description'),
                    confirmButtonText: _aui.I18n.getText('bitbucket.web.util.enforce.settings.warning.dialog.confirm'),
                    warning: false,
                    titleIconClass: 'aui-icon-small aui-iconfont-warning warning-icon',
                    classNames: 'restriction-warning-dialog'
                }).then(function () {
                    $form.submit();
                });
            } else {
                $form.submit();
            }
        });

        (0, _jquery2.default)('#branch-model-cancel').click(function (e) {
            e.preventDefault();

            if (repository && branchModel.scope.type === _enums.ScopeType.PROJECT) {
                //Never saved repository level
                (0, _jquery2.default)('#inherit-settings-selection-inherit').trigger('click').focus();
            } else {
                //Project level and previously saved repository level
                var errors = void 0;

                if (repository) {
                    errors = {
                        development: !developmentRefExists ? [_aui.I18n.getText('bitbucket.branchmodel.error.branchnotexist.development')] : null,
                        production: !productionRefExists ? [_aui.I18n.getText('bitbucket.branchmodel.error.branchnotexist.production')] : null
                    };
                }
                resetBranchModelForm(_extends({}, branchModel, {
                    cascadingMerge: cascadingMerge,
                    cascadingMergeMergeCheck: cascadingMergeMergeCheck,
                    cascadingMergeDisabled: cascadingMergeDisabled,
                    deleteSourceBranchDefault: deleteSourceBranchDefault
                }), significantBranchSelectors, errors);
                e.target.focus();
            }
        });

        if (repository) {
            var shouldShowInheritWarning = function shouldShowInheritWarning() {
                return branchModel.scope.type === _enums.ScopeType.REPOSITORY || hasBranchModelChanged(branchModel, getBranchModelFromForm(), developmentRefExists, productionRefExists);
            };
            var badCascadingMergeInherit = branchModel.scope.type === _enums.ScopeType.PROJECT && cascadingMerge && !releaseTypeEnabled(branchModel) && !productionRefExists;
            // Only warn when the action is destructive, i.e when switching from a saved repository config to an inherited one,
            // or when switching back to inherited from an unsaved, but changed, custom config
            var inheritSettingsToggle = new _inheritSettingsToggle2.default(getElById('inherit-settings-toggle'), shouldShowInheritWarning);
            inheritSettingsToggle.on('change', function (type) {
                var $form = (0, _jquery2.default)('.branch-model-settings-form');

                if (type === _inheritSettingsToggle.InheritanceType.INHERIT) {
                    toggleFormDisabled(true);

                    if (branchModel.scope.type === _enums.ScopeType.PROJECT) {
                        //This is the transition back to inherit, from custom, without ever having saved the custom configuration,
                        //so no need for a page pop, just reset the UI state.
                        $form.removeClass('scope-repository').addClass('scope-project');
                        var errors = {
                            development: !developmentRefExists ? [_aui.I18n.getText('bitbucket.branchmodel.error.branchnotexist.development')] : null,
                            production: !productionRefExists ? [_aui.I18n.getText('bitbucket.branchmodel.error.branchnotexist.production')] : null,
                            cascadingMerge: badCascadingMergeInherit ? [_aui.I18n.getText('bitbucket.branchmodel.error.cascadingmerge.noproduction', branchModel.production.refId)] : null
                        };

                        resetBranchModelForm(_extends({}, branchModel, {
                            cascadingMerge: cascadingMerge,
                            cascadingMergeMergeCheck: cascadingMergeMergeCheck,
                            cascadingMergeDisabled: cascadingMergeDisabled,
                            deleteSourceBranchDefault: deleteSourceBranchDefault
                        }), significantBranchSelectors, errors, true);
                    } else {
                        $form.submit();
                    }
                } else {
                    toggleFormDisabled(false);
                    $form.removeClass('scope-project').addClass('scope-repository');

                    if (!developmentRefExists) {
                        significantBranchSelectors.development.clear(false);
                        significantBranchSelectors.development.clearErrors();

                        //Firefox (only) needs time between enabling the form and clicking the form field, otherwise the click is lost (facepalm)
                        (0, _lodash.delay)(function () {
                            return getElById('branch-model-development-type-default').click();
                        }, 10);
                    }

                    if (!productionRefExists) {
                        significantBranchSelectors.production.clear(false);
                        significantBranchSelectors.production.clearErrors();

                        //Firefox (only) needs time between enabling the form and clicking the form field, otherwise the click is lost (facepalm)
                        (0, _lodash.delay)(function () {
                            return getElById('branch-model-production-type-none').click();
                        }, 10);
                    }

                    if (badCascadingMergeInherit) {
                        (0, _jquery2.default)('#branch-model-cascadingmerge-status').closest('fieldset').find('.error').remove();
                    }
                }
            });
        }
    }
});