'use strict';

define('bitbucket-plugin-branch/internal/feature/branch/merge-help/merge-help', ['bitbucket/internal/util/events'], function (events) {
    return {
        init: function init() {
            events.on('bitbucket.internal.DO_NOT_USE.pull-request.cant.merge', function (pullRequest, conflicted, vetoes, properties) {
                if (conflicted && properties) {
                    // send out an event to inform interested parties that the conflict resolution instructions have changed.
                    events.trigger('bitbucket.internal.DO_NOT_USE.branch.plugin.conflict.merge.help', null, {
                        stability: properties['branch.from-ref-stability'],
                        isCascadingMergeConflict: properties['branch.cascading-merge-conflict']
                    });
                }
            });
        }
    };
});