define('bitbucket-plugin-sourcetree/internal/sourcetree-clone/sourcetree-clone', [
    '@atlassian/aui',
    'jquery',
    'bitbucket/util/events',
    'bitbucket/util/navbuilder',
    'bitbucket/util/state',
    'exports',
], function (AJS, $, events, nav, pageState, exports) {
    /* Make this a client-web-panel one day... */
    var updateSourcetreeCloneUrl = function (cloneProtocol, cloneUrl) {
        var user = pageState.getCurrentUser();
        var sourceCloneUrl =
            'sourcetree://cloneRepo' +
            '?type=stash' +
            '&baseWebUrl=' +
            encodeURIComponent(window.location.origin + AJS.contextPath()) +
            '&cloneUrl=' +
            encodeURIComponent(cloneUrl);

        if (user) {
            sourceCloneUrl = sourceCloneUrl + '&user=' + encodeURIComponent(user.name);
        }
        $('#sourcetree-clone-button').attr('href', sourceCloneUrl);
    };

    exports.init = function () {
        events.on(
            'bitbucket.internal.DO_NOT_USE.feature.repository.clone.mirror.changed',
            updateSourcetreeCloneUrl
        );
        events.on(
            'bitbucket.internal.DO_NOT_USE.feature.repository.clone.protocol.changed',
            updateSourcetreeCloneUrl
        );
        events.on(
            'bitbucket.internal.DO_NOT_USE.feature.repository.clone.protocol.initial',
            updateSourcetreeCloneUrl
        );
    };
});
