define('bitbucket/internal/feature/emoticons/emoticons', [
    '@atlassian/aui',
    'jquery',
    'lodash',
    'bitbucket/util/navbuilder',
    'bitbucket/util/server',
    'bitbucket/internal/util/client-storage',
    'bitbucket/internal/util/function',
    'bitbucket/internal/util/highlight-text',
    'bitbucket/internal/util/markup',
    'bitbucket/internal/widget/markup-editor/markup-editor',
], function (AJS, $, _, nav, server, clientStorage, fn, highlightText, markupUtil, MarkupEditor) {
    'use strict';

    const EMOTICONS = {
        url: nav.rest('emoticons').addPathComponents('emoticons').build(),
        key: clientStorage.buildKey('emoticons', 'bitbucket-emoticons'),
        transform: function (values) {
            return _.chain(values).values().sortBy('shortcut').value();
        },
    };

    function atSettings(at, data) {
        return {
            at: at,
            limit: 100,
            search_key: 'shortcut',
            data: data,
            startWithSpace: false,
            callbacks: {
                matcher: escapingMatcher,
                tpl_eval: fn.argMap(
                    bitbucket.internal.feature.emoticons.emoticons.autocompleteRow,
                    1
                ),
                highlighter: bitbucketHighlight,
            },
        };
    }

    function bitbucketHighlight(li, query) {
        const $li = $(li);
        const $match = $li.find('span.shortcut');
        $match.html(highlightText.highlight($match.text(), query));

        return $li;
    }

    function destroy($editor) {
        $editor.find('textarea').atwho('destroy');
    }

    function fetch(emoji) {
        return server
            .rest({
                url: emoji.url,
            })
            .then(emoji.transform)
            .done(clientStorage.setSessionItem.bind(clientStorage, emoji.key));
    }

    function escapingMatcher(flag, subtext, startWithSpace) {
        const isMentioning = $('#mention-autocomplete-dialog').length > 0;

        if (!isMentioning && !markupUtil.isPositionInsideCodeBlock(subtext.length - 1, subtext)) {
            // prettier-ignore
            // eslint-disable-next-line dot-notation
            return $().atwho['default'].callbacks.matcher(
                    flag,
                    subtext,
                    startWithSpace
                );
        }

        return null;
    }

    function loadFromClientStorage() {
        return clientStorage.getSessionItem(EMOTICONS.key) || [];
    }

    /**
     * Adds keyhandlers for up/down navigation on the autocomplete
     */
    function registerKeyHandlers() {
        var ROW_HEIGHT_PX;
        $(document).on('keydown', 'textarea', function (evt) {
            if (evt.which === AJS.keyCode.UP || evt.which === AJS.keyCode.DOWN) {
                $('.atwho-view').each(function () {
                    const $el = $(this);
                    const $currentRow = $el.find('.emoticonRow.cur');

                    if (ROW_HEIGHT_PX === undefined) {
                        ROW_HEIGHT_PX = $currentRow.outerHeight();
                    }
                    $el.scrollTop($currentRow.index() * ROW_HEIGHT_PX);
                });
            }
        });
    }

    const loadEmoticons = _.once(function () {
        var emoticons = loadFromClientStorage();

        if (!emoticons || emoticons.length === 0) {
            emoticons = fetch(EMOTICONS);
        } else {
            emoticons = $.Deferred().resolve(emoticons);
        }

        return emoticons;
    });

    function init($editor) {
        _.defer(function () {
            loadEmoticons().done(function (emoticons) {
                $editor.find('textarea').atwho(atSettings(':', emoticons));
            });
        });
    }

    MarkupEditor.registerExtension({
        init: init,
        destroy: destroy,
    });
    registerKeyHandlers();
});
