define('bitbucket-plugin-repository-ref-sync/internal/feature/sync/button/ref-sync-button', [
    'bitbucket-plugin-repository-ref-sync/internal/feature/sync/dialog/ref-sync-dialog',
    'jquery',
    'bitbucket/util/navbuilder',
    'bitbucket/internal/model/page-state',
    'bitbucket/internal/util/ajax',
    'bitbucket/internal/util/events',
    'exports',
], function (RefSyncDialog, $, nav, pageState, ajax, events, exports) {
    'use strict';

    const syncButtonSelector = '.synchronize-ref';

    function getSyncUrl() {
        return nav
            .newBuilder([
                'rest',
                'sync',
                'latest',
                'projects',
                pageState.getProject().getKey(),
                'repos',
                pageState.getRepository().getSlug(),
            ])
            .build();
    }

    function checkSynchronized(revisionReference) {
        ajax.rest({
            url: getSyncUrl(),
            data: {
                at: revisionReference.getId(),
            },
        }).done(function (syncData) {
            // if data is null, then branch is in-sync
            // we only want to show manual synchronize button if branch has diverged
            const diverged = syncData && syncData.state === 'DIVERGED';
            $(syncButtonSelector).toggleClass('hidden', !diverged);
        });
    }

    exports.onReady = function () {
        const refSyncDialog = new RefSyncDialog();

        $(syncButtonSelector).on('click', function (e) {
            e.preventDefault();
            refSyncDialog.showFor(pageState.getRevisionRef());
        });

        checkSynchronized(pageState.getRevisionRef());
        events.on(
            'bitbucket.internal.DO_NOT_USE.layout.branch.revisionRefChanged',
            checkSynchronized
        );
    };
});
