define('bitbucket-plugin-repository-ref-sync/internal/feature/sync/common/ref-sync-common', [
    'bitbucket/util/navbuilder',
    'bitbucket/util/server',
    'bitbucket/util/state',
    'exports',
], function (nav, server, pageState, exports) {
    'use strict';

    function enableRefSyncing(enable) {
        return server.rest({
            url: nav.rest('sync').repository(pageState.getRepository()).build(),
            type: 'POST',
            data: {
                enabled: enable,
            },
        });
    }

    function getSyncUrl() {
        return nav
            .rest('sync')
            .repository(pageState.getRepository())
            .addPathComponents('synchronize')
            .build();
    }

    exports.enableRefSyncing = enableRefSyncing;
    exports.getSyncUrl = getSyncUrl;
});
