define('bitbucket-plugin-contributing-guidelines/internal/feature/clone/clone-link', ['exports', 'jquery', 'bitbucket-plugin-contributing-guidelines/internal/model/common', 'bitbucket/internal/util/analytics', 'bitbucket/util/navbuilder', 'bitbucket/util/state'], function (exports, _jquery, _common, _analytics, _navbuilder, _state) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.init = init;

    var _jquery2 = _interopRequireDefault(_jquery);

    var analytics = _interopRequireWildcard(_analytics);

    var nav = _interopRequireWildcard(_navbuilder);

    var _state2 = _interopRequireDefault(_state);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function init() {
        (0, _jquery2.default)('#repo-clone-dialog').one('aui-show', function () {
            // Replace the placeholder with the actual link
            var $placeholder = (0, _jquery2.default)('#contributing-guidelines-clone-placeholder');
            (0, _common.getContributingGuidelinesFilename)(_state2.default.getRepository()).done(function (filename) {
                $placeholder.html(bitbucketPluginContributingGuidelines.internal.feature.clone.cloneLink.link({
                    url: nav.repository(_state2.default.getRepository()).browse().path(filename).build()
                }));
                $placeholder.removeClass('hidden');
            });
            (0, _jquery2.default)('.contributing-info-link').on('click', function () {
                return analytics.add('contributing.clone.clicked');
            });
        });
    }
});