define('bitbucket-plugin-contributing-guidelines/internal/feature/pull-request-create/pr-create-link', ['exports', 'jquery', 'bitbucket-plugin-contributing-guidelines/internal/model/common', 'bitbucket/internal/util/analytics', 'bitbucket/internal/util/events', 'bitbucket/util/state'], function (exports, _jquery, _common, _analytics, _events, _state) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.init = init;

    var _jquery2 = _interopRequireDefault(_jquery);

    var analytics = _interopRequireWildcard(_analytics);

    var _events2 = _interopRequireDefault(_events);

    var _state2 = _interopRequireDefault(_state);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var guidelinesPromise = void 0;
    var guidelinesPath = void 0;

    function enterPrCreateState(data) {
        // When the user clicks the 'create' button and moves into the prCreate page (from the compare page) update whether
        // link should show.
        if (data.newForm === 'pullRequest') {
            updateLink();
        }
    }

    // We have a class variable for the link so that if people go 'back' on the PR create page, we are able to update whether
    // the link shows or not based on the new target repo but we don't have to actually load the file until they click on the link
    function updateLink() {
        var $contributingInfo = (0, _jquery2.default)('.pr-create-contributing-info');
        var targetRepo = _state2.default.getTargetBranch().repository;
        (0, _common.getContributingGuidelinesFilename)(targetRepo).done(function (path) {
            $contributingInfo.removeClass('hidden');
            guidelinesPath = path;
        }).fail(function () {
            $contributingInfo.addClass('hidden');
            guidelinesPath = null;

            return false;
        });
        guidelinesPromise = null;
    }

    // When a user clicks the link, we store the result of the promise so that next time they click it we don't need to load
    // it again from the server
    function clickLink() {
        var repository = _state2.default.getTargetBranch().repository;

        if (!guidelinesPromise) {
            guidelinesPromise = (0, _common.getContributingGuidelinesData)(repository, guidelinesPath);
        }
        analytics.add('contributing.prcreate.clicked');
        (0, _common.showContributingFileDialog)(guidelinesPromise);
    }

    function init() {
        // Show the guidelines when a user clicks on the link
        (0, _jquery2.default)('.contributing-info-link').on('click', clickLink);
        // When they navigate to the create page from the compare page, update the form fragment (in case the target repo changed).
        _events2.default.on('bitbucket.internal.DO_NOT_USE.feature.compare.form.state', enterPrCreateState);
        updateLink();
    }
});