define('bitbucket-plugin-contributing-guidelines/internal/model/common', ['exports', '@atlassian/aui', 'bitbucket/internal/model/path', 'bitbucket/util/navbuilder', 'bitbucket/util/server'], function (exports, _aui, _path, _navbuilder, _server) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.showContributingFileDialog = showContributingFileDialog;
    exports.getContributingGuidelinesData = getContributingGuidelinesData;
    exports.getContributingGuidelinesFilename = getContributingGuidelinesFilename;

    var AJS = _interopRequireWildcard(_aui);

    var _path2 = _interopRequireDefault(_path);

    var nav = _interopRequireWildcard(_navbuilder);

    var server = _interopRequireWildcard(_server);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function showContributingFileDialog(guidelinesPromise) {
        var dialog = AJS.dialog2(bitbucketPluginContributingGuidelines.internal.model.common.contributingDialog());
        dialog.$el.on('click', '.cancel-button', function () {
            return dialog.hide();
        });
        dialog.show();
        dialog.$el.find('.spinner').show().spin('large');

        guidelinesPromise.done(function (content) {
            dialog.$el.removeClass('loading');
            dialog.$el.find('.aui-dialog2-content').html(content);
        });
    }

    function getContributingGuidelinesData(targetRepo, path) {
        return server.rest({
            url: nav.rest().project(targetRepo.project.key).repo(targetRepo.slug).raw().path(new _path2.default(path).toString()).withParams({
                markup: true,
                htmlEscape: false,
                hardwrap: false
            }).build(),
            type: 'GET',
            dataType: 'text'
        });
    }

    function getContributingGuidelinesFilename(targetRepo) {
        return server.rest({
            url: nav.rest('contributing-guidelines').project(targetRepo.project.key).repo(targetRepo.slug).build(),
            statusCode: {
                '*': false
            }
        });
    }
});