define('bitbucket-plugin-gpg/internal/gpg/table/gpg-keys-table', ['exports', '@atlassian/aui', 'jquery', 'bitbucket/internal/util/ajax', 'bitbucket/internal/widget/are-you-sure/are-you-sure', 'bitbucket/internal/widget/paged-table/paged-table', 'bitbucket/util/navbuilder'], function (exports, _aui, _jquery, _ajax, _areYouSure, _pagedTable, _navbuilder) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.init = init;

    var _jquery2 = _interopRequireDefault(_jquery);

    var ajax = _interopRequireWildcard(_ajax);

    var _areYouSure2 = _interopRequireDefault(_areYouSure);

    var _pagedTable2 = _interopRequireDefault(_pagedTable);

    var nav = _interopRequireWildcard(_navbuilder);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    var _get = function get(object, property, receiver) {
        if (object === null) object = Function.prototype;
        var desc = Object.getOwnPropertyDescriptor(object, property);

        if (desc === undefined) {
            var parent = Object.getPrototypeOf(object);

            if (parent === null) {
                return undefined;
            } else {
                return get(parent, property, receiver);
            }
        } else if ("value" in desc) {
            return desc.value;
        } else {
            var getter = desc.get;

            if (getter === undefined) {
                return undefined;
            }

            return getter.call(receiver);
        }
    };

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var GpgKeysTable = function (_PagedTable) {
        _inherits(GpgKeysTable, _PagedTable);

        function GpgKeysTable(options) {
            _classCallCheck(this, GpgKeysTable);

            var _this = _possibleConstructorReturn(this, (GpgKeysTable.__proto__ || Object.getPrototypeOf(GpgKeysTable)).call(this, options));

            _this.restBuilder = options.restBuilder;
            _this.hasInitialised = false;
            return _this;
        }

        _createClass(GpgKeysTable, [{
            key: 'buildUrl',
            value: function buildUrl(start, limit) {
                var builder = this.restBuilder().withParams({ start: start, limit: limit });

                return builder.build();
            }
        }, {
            key: 'handleNewRows',
            value: function handleNewRows(page, attachmentMethod) {
                var rows = bitbucketPluginGpg.internal.gpg.table.gpgKeysTable.rows({ keys: page.values });
                this.$table.find('tbody')[attachmentMethod](rows);
            }
        }, {
            key: 'spin',
            value: function spin($button) {
                var $spinner = (0, _jquery2.default)('<div class="spinner" />');
                $spinner.insertAfter($button);
                $button.addClass('hidden');
                $spinner.spin('small');

                return $spinner;
            }
        }, {
            key: 'unspin',
            value: function unspin($spinner, $button) {
                $spinner.spinStop().remove();
                $button.removeClass('hidden');
            }
        }, {
            key: 'switchToNoResults',
            value: function switchToNoResults() {
                var $topAddKeyButton = (0, _jquery2.default)('#gpg-add-key-button');
                var $help = (0, _jquery2.default)('#gpg-help');
                $topAddKeyButton.remove();
                $help.remove();
                (0, _jquery2.default)(bitbucket.internal.widget.pagedTable.pagedTable.pagedTableMessage({
                    content: bitbucketPluginGpg.internal.gpg.table.gpgKeysTable.noResults({
                        addKeyUrl: $topAddKeyButton.attr('href'),
                        content: $help.wrap('<div />').parent().html()
                    })
                })).insertAfter(this.$table.addClass('no-rows'));
            }
        }, {
            key: 'init',
            value: function init() {
                var _this2 = this;

                if (!this.$table.is(':visible')) {
                    this.suspend();
                    (0, _jquery2.default)('#page').on('tabSelect', '.tabs-menu a', function (e) {
                        var $target = (0, _jquery2.default)(e.target);

                        if ($target.attr('id') === 'gpg-tab') {
                            if (!_this2.hasInitialised) {
                                _get(GpgKeysTable.prototype.__proto__ || Object.getPrototypeOf(GpgKeysTable.prototype), 'init', _this2).call(_this2);
                                _this2.hasInitialised = true;
                            }
                            _this2.resume();
                        } else {
                            _this2.suspend();
                        }
                    });
                } else {
                    _get(GpgKeysTable.prototype.__proto__ || Object.getPrototypeOf(GpgKeysTable.prototype), 'init', this).call(this);
                    this.hasInitialised = true;
                }
                this.$table.on('click', '.delete-action', function (e) {
                    var $button = (0, _jquery2.default)(e.target);
                    var $tr = $button.closest('tr');
                    var id = $tr.attr('data-key-id');
                    var fingerprint = $tr.attr('data-key-fingerprint');
                    var builder = _this2.restBuilder().addPathComponents(fingerprint);
                    e.preventDefault();

                    (0, _areYouSure2.default)({
                        title: _aui.I18n.getText('bitbucket.plugins.gpg.delete.title'),
                        bodyContent: bitbucketPluginGpg.internal.gpg.table.gpgKeysTable.deleteDialogContent({
                            fingerprint: id
                        }),
                        confirmButtonText: _aui.I18n.getText('bitbucket.plugins.gpg.delete.confirm')
                    }).done(function () {
                        var $spinner = _this2.spin($button);

                        return ajax.rest({
                            url: builder.build(),
                            type: 'DELETE'
                        }).done(function () {
                            var $tBody = $tr.parent();
                            $tr.remove();
                            (0, _aui.flag)({
                                type: 'success',
                                close: 'auto',
                                body: bitbucketPluginGpg.internal.gpg.table.gpgKeysTable.deletedFlag({})
                            });
                            if ($tBody.children().length === 0) {
                                _this2.switchToNoResults();
                            }
                        }).always(function () {
                            _this2.unspin($button, $spinner);
                        });
                    });
                });
            }
        }]);

        return GpgKeysTable;
    }(_pagedTable2.default);

    function init(target, user) {
        var keysTable = new GpgKeysTable({
            target: target,
            restBuilder: function restBuilder() {
                var builder = nav.rest('gpg').addPathComponents('keys');

                if (user) {
                    builder = builder.withParams({ user: user });
                }

                return builder;
            }
        });
        keysTable.init();
    }
});