define('bitbucket-plugin-ref-restriction/internal/model/ref-matcher', [
    '@atlassian/backbone-brace',
    'jquery',
    './ref-matcher-type',
    './supported-matcher-types',
], function (Brace, $, RefMatcherType, SupportedMatcherTypes) {
    'use strict';

    var RestrictionMatcher = Brace.Model.extend({
        namedAttributes: {
            id: 'string',
            displayId: 'string',
            active: 'boolean',
            type: RefMatcherType,
        },
        setDetails: function (details) {
            return this.set($.extend(true, this.toJSON(), details));
        },
        equals: function (that) {
            return (
                this.id === that.id &&
                this.getType().getId().toUpperCase() === that.getType().getId().toUpperCase()
            );
        },
        branch: function (ref) {
            ref = ref || {};

            return this.set({
                id: ref.id || '',
                displayId: ref.displayId || '',
                type: new RefMatcherType().setDetails({
                    id: SupportedMatcherTypes.BRANCH,
                }),
            });
        },
        pattern: function (pattern) {
            return this.set({
                id: pattern,
                displayId: pattern,
                type: new RefMatcherType().setDetails({
                    id: SupportedMatcherTypes.PATTERN,
                }),
            });
        },
        model: function (id, isBranch) {
            return this.set({
                id: id,
                displayId: id,
                type: new RefMatcherType().setDetails({
                    id: isBranch
                        ? SupportedMatcherTypes.MODEL_BRANCH
                        : SupportedMatcherTypes.MODEL_CATEGORY,
                }),
            });
        },
    });

    return RestrictionMatcher;
});
