define('bitbucket-plugin-ref-restriction/internal/model/ref-restriction-collection', [
    '@atlassian/backbone-brace',
    'lodash',
    './ref-restriction',
], function (Brace, _, RefRestriction) {
    'use strict';

    /**
     * @param {number} id
     * @param {Object} details
     * @this {RefRestrictionCollection}
     */
    function setRestrictedRefDetails(details, id) {
        var refRestriction = this.get(id);

        if (refRestriction) {
            refRestriction.setDetails(details);
        }
    }

    var RefRestrictionCollection = Brace.Collection.extend({
        model: RefRestriction,

        setDetails: function (detailsById) {
            _.forEach(detailsById, setRestrictedRefDetails.bind(this));
        },
    });

    return RefRestrictionCollection;
});
