define('bitbucket-plugin-ref-restriction/internal/model/ref-restriction', [
    '@atlassian/backbone-brace',
    'lodash',
    'bitbucket/util/navbuilder',
    'bitbucket/util/state',
    'bitbucket/internal/util/ajax',
    'bitbucket/internal/util/scope-type',
    './ref-matcher',
], function (Brace, _, nav, pageState, ajax, scopeTypeUtil, RefMatcher) {
    'use strict';

    function getRestrictionsUrl(scopeType, id) {
        var currentScopeMethod = scopeTypeUtil.scopeNavAndStateMethod(scopeType);
        var target = pageState[currentScopeMethod.state]();
        var navMethod = currentScopeMethod.nav;

        var builder = nav
            .rest('branch-permissions', 'latest')
            [navMethod](target)
            .addPathComponents('restrictions');

        if (id) {
            builder = builder.addPathComponents(id);
        }

        return builder.build();
    }

    var RefRestriction = Brace.Model.extend({
        namedAttributes: {
            id: 'number',
            repositoryId: null,
            scope: Object,
            type: 'string',
            matcher: RefMatcher,
            users: [Object],
            groups: ['string'],
            accessKeys: [Object],
        },
        setDetails: function (details) {
            return this.set(details);
        },
        getCallbackObject: function (response) {
            return {
                type: this.id ? 'PUT' : 'POST',
                refRestriction: this.setDetails(response),
            };
        },
        getRestDetails: function () {
            var attributes = _.clone(this.attributes);

            if (attributes.users) {
                attributes.users = _.map(attributes.users, 'name');
            }
            if (attributes.accessKeys) {
                attributes.accessKeys = _.map(attributes.accessKeys, 'key.id');
            }

            return attributes;
        },
        save: function (errorHandler) {
            return ajax
                .rest({
                    url: getRestrictionsUrl(this.getScope()),
                    data: this.getRestDetails(),
                    type: 'POST',
                    statusCode: {
                        400: errorHandler,
                        409: errorHandler,
                    },
                })
                .then(this.getCallbackObject);
        },
        remove: function () {
            var self = this;

            return ajax
                .rest({
                    url: getRestrictionsUrl(this.getScope(), this.id),
                    type: 'DELETE',
                })
                .then(function () {
                    return {
                        type: 'DELETE',
                        id: self.id,
                    };
                });
        },
    });

    return RefRestriction;
});
