define('bitbucket-plugin-jira/internal/feature/jira/comment/comment-jira-issues', ['exports', 'jquery', 'lodash', 'bitbucket/internal/feature/comments/comment-async-web-panel', 'bitbucket/internal/util/events', 'bitbucket/util/server', '../issue-list/jira-issue-list'], function (exports, _jquery, _lodash, _commentAsyncWebPanel, _events, _server, _jiraIssueList) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.issueListView = undefined;

    var _jquery2 = _interopRequireDefault(_jquery);

    var _commentAsyncWebPanel2 = _interopRequireDefault(_commentAsyncWebPanel);

    var _events2 = _interopRequireDefault(_events);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var commentsJiraIssues = void 0;

    /**
     * Use commentAsyncWebPanel to render the Jira issue list after the webpanel is loaded
     * @param {Object} context Context provided by the client-web-panel
     * @returns {String} Jira issue list HTML
     */
    function issueListView(context) {
        if (!commentsJiraIssues) {
            commentsJiraIssues = {};
            (0, _jiraIssueList.addIssueListDialog)(reloadIssues);
            _events2.default.on('bitbucket.internal.DO_NOT_USE.util.oauth.authorizationSucceeded', reloadIssues);
            _events2.default.on('bitbucket.internal.DO_NOT_USE.jira.issueCreated', function (commentId, issueKey) {
                commentsJiraIssues[commentId].loadIssues([issueKey]);
            });
        }

        return _commentAsyncWebPanel2.default.getWebPanelEl(function ($placeholder) {
            var issueKeys = (0, _lodash.get)(context, 'comment.properties.issues');
            commentsJiraIssues[context.comment.id] = new _jiraIssueList.IssueList(issueKeys, $placeholder);
        });
    }

    function reloadIssues() {
        (0, _jquery2.default)('.jira-issues-authenticate').closest('.comment').each(function (index, comment) {
            return commentsJiraIssues[comment.getAttribute('data-id')].loadIssues();
        });
    }

    exports.issueListView = issueListView;
});