define('bitbucket-plugin-jira/internal/feature/jira/commit/commit-jira-issues', ['exports', 'jquery', 'bitbucket/internal/util/shortcuts', 'bitbucket/internal/util/string-replacer', '../dialog/dialog', '../key-linker/key-linker', '../key-matcher/jira-key-matcher'], function (exports, _jquery, _shortcuts, _stringReplacer, _dialog, _keyLinker, _jiraKeyMatcher) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.onReady = onReady;

    var _jquery2 = _interopRequireDefault(_jquery);

    var shortcuts = _interopRequireWildcard(_shortcuts);

    var _stringReplacer2 = _interopRequireDefault(_stringReplacer);

    var _dialog2 = _interopRequireDefault(_dialog);

    var _jiraKeyMatcher2 = _interopRequireDefault(_jiraKeyMatcher);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    /* global jira: true */

    var commitJiraIssuesTriggerClassName = 'commit-issues-trigger';

    function commitMessageJiraKeyLinker(str, metadata) {
        for (var _len = arguments.length, args = Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
            args[_key - 2] = arguments[_key];
        }

        return _keyLinker.jiraKeyLinker.apply(undefined, [str, _extends({
            className: commitJiraIssuesTriggerClassName
        }, metadata)].concat(args));
    }

    var commitPageMessageEnricher = new _stringReplacer2.default();

    commitPageMessageEnricher.registerReplacer(commitMessageJiraKeyLinker, _keyLinker.DEFAULT_JIRA_LINKER_WEIGHT, _jiraKeyMatcher2.default);

    function initJiraIssues(triggerClassName) {
        var triggerSelector = '.' + triggerClassName;

        new _dialog2.default({
            id: 'commit-jira-issues-dialog',
            triggerSelector: triggerSelector
        });

        shortcuts.bind('showJiraIssuesDialog', function () {
            /**
             * BSERV-13647: We open the dialog by triggering a click event
             * directly on the trigger, this is required as the 'jira-issues-dialog-trigger'
             * don't set the issue key until the trigger's click event.
             *
             *  https://stash.atlassian.com/projects/CP/repos/jira-integration-plugin/browse/plugin/src/main/resources/jira-issues-dialog-trigger/jira-issues-dialog-trigger.js#58
             */

            var commitTrigger = (0, _jquery2.default)(triggerSelector)[0];

            if (commitTrigger) {
                commitTrigger.click();
            }
        });
    }

    function onReady() {
        _PageDataPlugin.ready('com.atlassian.bitbucket.server.bitbucket-jira:jira-issues-commit-provider', 'bitbucket.page.commit', function (data) {
            if (data.issues.length > 0) {
                (0, _jquery2.default)('.jira-issues-placeholder').replaceWith(bitbucketPluginJira.internal.feature.jira.commit.jiraIssuesCommitMetadataPanel.commitMetadataPanel(data));
                initJiraIssues(commitJiraIssuesTriggerClassName);
            }
        });
    }
});