define('bitbucket-plugin-jira/internal/feature/jira/commits/commits-jira-issues', ['exports', 'jquery', 'bitbucket/internal/feature/commits/commit-message-enricher', 'bitbucket/internal/util/events', '../dialog/dialog', '../key-linker/key-linker', '../key-matcher/jira-key-matcher'], function (exports, _jquery, _commitMessageEnricher, _events, _dialog, _keyLinker, _jiraKeyMatcher) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.onReady = onReady;

    var _jquery2 = _interopRequireDefault(_jquery);

    var _commitMessageEnricher2 = _interopRequireDefault(_commitMessageEnricher);

    var _events2 = _interopRequireDefault(_events);

    var _dialog2 = _interopRequireDefault(_dialog);

    var _jiraKeyMatcher2 = _interopRequireDefault(_jiraKeyMatcher);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    var commitsTableJiraIssuesTriggerClassName = 'commits-issues-trigger';
    var commitsTableIssuesSelector = '.commit-list-jira-issues-col';
    var commitsTableSelector = '.commits-table';

    function commitMessageJiraKeyLinker(str, metadata) {
        for (var _len = arguments.length, args = Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
            args[_key - 2] = arguments[_key];
        }

        return _keyLinker.jiraKeyLinker.apply(undefined, [str, _extends({
            className: commitsTableJiraIssuesTriggerClassName
        }, metadata)].concat(args));
    }

    _commitMessageEnricher2.default.registerReplacer(commitMessageJiraKeyLinker, _keyLinker.DEFAULT_JIRA_LINKER_WEIGHT, _jiraKeyMatcher2.default);

    function displayIssuesColumn() {
        var $table = (0, _jquery2.default)(commitsTableSelector);

        if ($table.find(commitsTableIssuesSelector + ' > a').length) {
            $table.find(commitsTableIssuesSelector).show();
        } else {
            $table.find(commitsTableIssuesSelector).hide();
        }
    }

    function onReady() {
        new _dialog2.default({
            id: 'commits-jira-issues-dialog',
            triggerSelector: '.' + commitsTableJiraIssuesTriggerClassName
        });

        _events2.default.on('bitbucket.internal.DO_NOT_USE.widget.commitsTable.serverContentAdded', displayIssuesColumn);
        _events2.default.on('bitbucket.internal.DO_NOT_USE.widget.commitsTable.contentAdded', displayIssuesColumn);
        displayIssuesColumn();
    }
});