define('bitbucket-plugin-jira/internal/feature/jira/dialog/dialog', ['module', 'exports', 'lodash', 'bitbucket/internal/util/ajax', 'bitbucket/internal/util/events', 'bitbucket/util/state', '../integration/dialog', '../integration/triggers'], function (module, exports, _lodash, _ajax2, _events, _state, _dialog, _triggers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _lodash2 = _interopRequireDefault(_lodash);

    var _ajax = _interopRequireWildcard(_ajax2);

    var _events2 = _interopRequireDefault(_events);

    var _state2 = _interopRequireDefault(_state);

    var _dialog2 = _interopRequireDefault(_dialog);

    var _triggers2 = _interopRequireDefault(_triggers);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    function StashJiraIssuesDialog(options) {
        _lodash2.default.bindAll(this, 'show', 'hide', 'showDialog', 'closeDialog', 'destroy');
        options = _extends({}, this.defaults, options);

        if (options.triggerSelector) {
            this._triggerInfo = _triggers2.default.init({
                selector: options.triggerSelector,
                headerTitleFn: typeof options.headerTitle === 'function' ? options.headerTitle : undefined
            }, options);
            this._dialog = this._triggerInfo.getDialog();
        } else {
            this._dialog = new _dialog2.default(options);
        }
    }

    StashJiraIssuesDialog.prototype.defaults = _extends({}, _dialog2.default.prototype.defaults, {
        ajax: function ajax(options) {
            return _ajax.rest(_extends({
                statusCode: {
                    // these are handled by plugin
                    200: false,
                    500: false
                }
            }, options));
        },
        authSuccessCallback: function authSuccessCallback() {
            return _events2.default.trigger('bitbucket.internal.DO_NOT_USE.util.oauth.authorizationSucceeded');
        },
        entityKey: _state2.default.getProject() ? _state2.default.getProject().key : null
    });

    StashJiraIssuesDialog.prototype.destroy = function () {
        this._dialog.destroy();
        this._dialog = null;
        if (this._triggerInfo) {
            this._triggerInfo.unbind();
            this._triggerInfo = null;
        }
    };

    StashJiraIssuesDialog.prototype.showDialog = StashJiraIssuesDialog.prototype.show = function () {
        this._dialog.show();
    };

    StashJiraIssuesDialog.prototype.closeDialog = StashJiraIssuesDialog.prototype.hide = function () {
        this._dialog.hide();
    };

    StashJiraIssuesDialog.prototype.setIssueKeys = function (keys) {
        this._dialog.setIssueKeys(keys);
    };

    exports.default = StashJiraIssuesDialog;
    module.exports = exports['default'];
});