define('bitbucket-plugin-jira/internal/feature/jira/file-history/file-history-jira-issues', ['exports', 'bitbucket/internal/feature/filebrowser/file-table-history/file-table-history', '../dialog/dialog', '../key-linker/key-linker', '../key-matcher/jira-key-matcher'], function (exports, _fileTableHistory, _dialog, _keyLinker, _jiraKeyMatcher) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.onReady = onReady;

    var _fileTableHistory2 = _interopRequireDefault(_fileTableHistory);

    var _dialog2 = _interopRequireDefault(_dialog);

    var _jiraKeyMatcher2 = _interopRequireDefault(_jiraKeyMatcher);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    function onReady() {
        var fileTableJiraIssuesTriggerClassName = 'file-table-jira-issues-trigger';

        function fileHistoryJiraKeyLinker(str, metadata) {
            for (var _len = arguments.length, args = Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
                args[_key - 2] = arguments[_key];
            }

            return _keyLinker.jiraKeyLinker.apply(undefined, [str, _extends({
                className: fileTableJiraIssuesTriggerClassName
            }, metadata)].concat(args));
        }

        _fileTableHistory2.default.commitMessageEnrichment.registerReplacer(fileHistoryJiraKeyLinker, _keyLinker.DEFAULT_JIRA_LINKER_WEIGHT, _jiraKeyMatcher2.default);

        var jiraIssuesDialog = new _dialog2.default({
            id: 'file-history-jira-issues-dialog',
            triggerSelector: '.' + fileTableJiraIssuesTriggerClassName
        });
    }
});