define('bitbucket-plugin-jira/internal/feature/jira/issue-list/jira-issue-list', ['exports', 'jquery', 'lodash', 'bitbucket/internal/util/oauth', 'bitbucket/util/navbuilder', 'bitbucket/util/server', '../dialog/dialog'], function (exports, _jquery, _lodash, _oauth, _navbuilder, _server, _dialog) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.addIssueListDialog = exports.IssueList = undefined;

    var _jquery2 = _interopRequireDefault(_jquery);

    var nav = _interopRequireWildcard(_navbuilder);

    var _dialog2 = _interopRequireDefault(_dialog);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    // Only needs to be initiated once per page
    var addIssueListDialog = function addIssueListDialog() {
        new _dialog2.default({
            id: 'jira-issue-list-dialog',
            triggerSelector: '.jira-issue-list-trigger'
        });
    };

    var getIssuesJsonUrl = function getIssuesJsonUrl(issueKeys) {
        return nav.rest('jira-integration').addPathComponents('issues').withParams({
            issueKey: issueKeys,
            fields: 'issuetype,status,summary',
            showErrors: true
        }).build();
    };

    var IssueList = function () {
        function IssueList() {
            var issueKeys = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
            var $issueList = arguments[1];

            _classCallCheck(this, IssueList);

            this.errors = [];
            this.$issueList = $issueList;
            // provide full list of issues to Jira issues dialog (including unresolved issues)
            this.issues = issueKeys.reduce(function (issues, issueKey) {
                return _extends({}, issues, _defineProperty({}, issueKey, { key: issueKey }));
            }, {});

            this.loadIssues();
        }

        _createClass(IssueList, [{
            key: 'addIssues',
            value: function addIssues(issuesJson) {
                var _this = this;

                var errors = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];

                this.errors = errors;
                if (Array.isArray(issuesJson)) {
                    issuesJson.forEach(function (issue) {
                        return _this.issues[issue.key] = issue;
                    });
                }
                this.render();
            }
        }, {
            key: 'loadIssues',
            value: function loadIssues(keysProvided) {
                var _this2 = this;

                var issueKeys = keysProvided || (0, _lodash.keys)(this.issues);

                if (issueKeys.length > 0) {
                    (0, _server.rest)({
                        url: getIssuesJsonUrl(issueKeys),
                        statusCode: {
                            200: false,
                            500: false // let Jira integration plugin handle communication errors
                        }
                    }).done(function (data) {
                        // Jira integration plugin wraps multiple responses in an extra array, hence the weird way to access them
                        var multipleErrors = (0, _lodash.get)(data, 'errors.0');
                        var errors = multipleErrors && multipleErrors.length ? multipleErrors : data.errors;
                        var issuesJson = (0, _lodash.get)(data, 'issues.0');
                        _this2.addIssues(issuesJson, errors);
                    }).fail(function (xhr) {
                        var errors = (0, _lodash.get)(xhr.responseJSON, 'errors', []).map(function (error) {
                            return _extends({}, error, {
                                status: xhr.status
                            });
                        });
                        _this2.addIssues(null, errors);
                    });
                }
            }
        }, {
            key: 'render',
            value: function render() {
                var $issueList = (0, _jquery2.default)(bitbucketPluginJira.internal.feature.jira.issueList.jiraIssueList.issueList({
                    authenticationErrors: this.errors.filter(function (error) {
                        return error.authenticationUri;
                    }),
                    resolvedIssues: (0, _lodash.values)(this.issues).filter(function (issue) {
                        return issue.fields;
                    }),
                    unresolvedIssues: (0, _lodash.values)(this.issues).filter(function (issue) {
                        return !issue.fields;
                    })
                }));
                $issueList.find('.jira-issue-status-lozenge').removeAttr('data-tooltip');
                this.$issueList.replaceWith($issueList);
                this.$issueList = $issueList;
            }
        }]);

        return IssueList;
    }();

    exports.IssueList = IssueList;
    exports.addIssueListDialog = addIssueListDialog;
});