define('bitbucket-plugin-jira/internal/feature/jira/key-linker/key-linker', ['module', 'exports', 'lodash', 'bitbucket/util/navbuilder'], function (module, exports, _lodash, _navbuilder) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _lodash2 = _interopRequireDefault(_lodash);

    var nav = _interopRequireWildcard(_navbuilder);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    /* global jiraIntegration:false */
    function getJiraKeysByRegex(str) {
        /*
         * This regex attempts to match Jira issue keys in the same way as the JAVA PatternJiraKeyScanner: https://goo.gl/e6Osvb
         * Since JS can't make use of negative lookaheads and lookbehinds, we have to resort to using capture groups instead.
         *
         * ([a-z]-|[\s!"#$%&'()\*\+,./:;<=>\?@\[\]^_`\{|\}~]|^)
         * Ensures the issue key can be preceded by 1 of 3 things:
         *   1) a lower case letter followed by a dash. So we can have issue keys after dashes
         *      but they cannot be after things that look like Bamboo builds or Crucible keys.
         *   2) whitespace or punctuation marks, excluding a dash.
         *   3) the beginning of a line.
         *
         * (([A-Z][A-Z0-9_]+)-([0-9]+))
         * Matches the issue key itself.
         *
         * (\b|_)
         * Requires a word boundary or an underscore at the end.
         */
        var jiraKeyRegEx = /([a-z]-|[\s!"#$%&'()\*\+,./:;<=>\?@\[\]^_`\{|\}~\u2000-\u206F\u2E00-\u2E7F]|^)(([A-Z][A-Z0-9_]+)-([0-9]+))(\b|_)/g;
        var results = [];
        var match = void 0;

        /*eslint no-cond-assign:0*/
        while (match = jiraKeyRegEx.exec(str)) {
            results.push(match[2]);
            // This is because of the (\b|_) at the end of the regex
            // we want to remove it for the next matching attempt
            jiraKeyRegEx.lastIndex--;
        }

        return results;
    }

    var DEFAULT_JIRA_LINKER_WEIGHT = 10;

    /**
     * @param {String} str - the full unmanipulated string to replace
     * @param {Object} metadata - used to manipulate the string
     * @returns {Object} with 'find' & 'replace' props
     */
    exports.default = {
        jiraKeyLinker: function jiraKeyLinker(str) {
            var metadata = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

            var hasJiraKeyProp = _lodash2.default.has(metadata, 'properties.jira-key');
            var jiraKeyMatches = [];

            if (!hasJiraKeyProp) {
                // if jira-key prop is missing, use regex instead
                jiraKeyMatches = getJiraKeysByRegex(str);

                if (!jiraKeyMatches.length) {
                    // Don't reject, to allow any other registered replacers work
                    return Promise.resolve([]);
                }
            }

            var jiraKeys = hasJiraKeyProp ? metadata.properties['jira-key'] : jiraKeyMatches;

            return Promise.resolve(jiraKeys.map(function (jiraKey) {
                var jiraLinkMarkup = jiraIntegration.templates.trigger.issuesTrigger({
                    className: metadata.className,
                    issues: [{
                        key: jiraKey,
                        url: nav.pluginServlets().path('jira-integration', 'issues', jiraKey).build()
                    }]
                });

                return {
                    find: jiraKey,
                    replace: jiraLinkMarkup
                };
            }));
        },


        DEFAULT_JIRA_LINKER_WEIGHT: DEFAULT_JIRA_LINKER_WEIGHT
    };
    module.exports = exports['default'];
});