var Chaperone = {
    _internal: {},
};

Chaperone._internal.syncing = (function () {
    /**
     * Goes to the server and sets the steps that have already been dismissed as "dismissed"
     * @returns {jQuery.Deferred}
     */
    function syncFromServer(key, $) {
        // eslint-disable-next-line no-undef
        return ($ || AJS.$).ajax({
            // eslint-disable-next-line no-undef
            url: AJS.contextPath() + '/rest/chaperone/1/chaperone/' + key,
        });
    }

    /**
     * Sends to the server a json array containing the selectors of the steps that have been dismissed.
     * @returns {jQuery.Deferred}
     */
    function syncToServer(key, value, $) {
        // eslint-disable-next-line no-undef
        return ($ || AJS.$).ajax({
            // eslint-disable-next-line no-undef
            url: AJS.contextPath() + '/rest/chaperone/1/chaperone/' + key,
            type: 'PUT',
            data: {
                json: value,
            },
        });
    }

    return {
        syncToServer: syncToServer,
        syncFromServer: syncFromServer,
    };
})();
