UPM.define('CertificateDetailsView',
    [
        'jquery',
        'underscore',
        'BaseView',
        'CertificateDetailsTemplate',
        'UpmFormats'
    ], function($,
                _,
                BaseView,
                CertificateDetailsTemplate,
                UpmFormats) {

    "use strict";


    return BaseView.extend({

        _initEvents: function() {
            this.listenTo(this.model, 'change', this.render, this);
        },

        template: CertificateDetailsTemplate,

        _getData: function() {
            return {
                certificate: this.model.toJSON(),
                expirationDate: UpmFormats.prettyDate(this.model.getExpirationDate())
            };
        }
    });
});
