 UPM.define('UploadDialog',
    [
        'jquery',
        'InstallParams',
        'UpmDialog',
        'UploadDialogTemplate'
    ],
    function($,
             InstallParams,
             UpmDialog,
             UploadDialogTemplate) {

    // Dialog for uploading an add-on or application.  Depending on system permissions, the user may select either
    // a local file to upload or a URL.

    // Due to limitations on how HTML file chooser controls and form posts work, in order for a file upload to be
    // retryable (e.g. in case the XSRF token has expired) we have to keep the original form around in the DOM even
    // after the dialog has been closed.  To do this, we pass a hidden JQuery element in the "formContainer" option
    // of the dialog, and UploadDialog moves its own form element into that container before closing itself.  You
    // shouldn't need to worry about the details of this if you do everything through the UpmInstaller module.

    return UpmDialog.extend({
        template: UploadDialogTemplate,

        events: {
            'input #upm-upload-file,#upm-upload-sig,#upm-upload-url': '_validateRequiredFields',
            'change #upm-upload-file,#upm-upload-sig,#upm-upload-url': '_validateRequiredFields',
            'keyup #upm-upload-file,#upm-upload-sig,#upm-upload-url': '_validateRequiredFields'
        },

        _postInitialize: function() {
            if (this.options.formContainer) {
                this.options.formContainer.empty();
            }
            $('.ffi input[type="file"]').fancyFileInput();
        },

        _getReturnValue: function () {
            return {
                file: this._getSelectedFile(),
                url: this._getSelectedUrl(),
                signature: this._getSelectedSignature(),
            };
        },

        _getSelected: function(name) {
            var v = this.$el.find(name).val();
            return (v && v.trim()) || null;
        },

        _setSelected: function(name, value) {
            var v = this.$el.find(name);
            v.val(value);
        },


        _isSignatureRequired: function() {
            return this._isPresent('#upm-upload-sig').length
        },

        _isPresent: function(name) {
            return this.$el.find(name) != null;
        },

        _getSelectedFile: function() {
            return this._getSelected('#upm-upload-file');
        },

        _getSelectedSignature: function() {
            let sigString = this._getSelected('#upm-upload-sig');
            try {
                return JSON.parse(sigString);
            } catch (e) {
                return {"signature" : sigString };
            }
        },

        _jsonifySignature: function() {
            let sign = this._getSelectedSignature();
            this._setSelected('#upm-upload-sig', JSON.stringify(sign));
        },

        _getSelectedUrl: function() {
            return this._getSelected('#upm-upload-url');
        },

        _isFileSelected() {
            return this._getSelectedFile();
        },

        _isUrlSelected() {
            return this._getSelectedUrl();
        },

        _isSubmittable: function() {
            var sig = this._getSelectedSignature();

            if (this._isSignatureRequired() && ! sig) {
                return false;
            }
            return this._isFileSelected() || this._isUrlSelected();
        },


        _onConfirm: function() {
            if (this._isSubmittable) {
                var result;
                if (this._isFileSelected()) {
                    result = new InstallParams({ filePath: this._getSelectedFile(), signature: this._getSelectedSignature() });
                    if (this.options.formContainer) {
                        var $form = this.$el.find('form');
                        this.hide();
                        // The signature can be passed as a simple String, the endpoint wits for JSON data.
                        this._jsonifySignature();
                        $form.remove();
                        this.options.formContainer.append($form);
                    }
                } else {
                    result = new InstallParams({ url: this._getSelectedUrl(), signature: this._getSelectedSignature() });
                }
                this.close();
                this.deferredResult.resolve(result);
            }
        },

        _postRender: function() {
            this._validateRequiredFields();
        },

        _validateRequiredFields: function() {
            var disable = !this._isSubmittable(),
                $button = this.$el.find('.confirm'),
                $filename = this.$el.find('.selected-file');

            if (this._getSelectedFile()) {
                $filename.html(new InstallParams({ filePath: this._getSelectedFile(), signature: this._getSelectedSignature() }).getFileName());
            } else {
                $filename.html('');
            }
            $button.prop('disabled', disable).attr('aria-disabled', disable).toggleClass('disabled', disable);
        }
    });
});
