'use strict';

define('bitbucket-plugin-search/internal/component/search-analytics-utils', ['jquery', 'lodash'], function ($, _) {
    var WEB_ITEM_KEY_MAP = {
        'com.atlassian.bitbucket.server.bitbucket-server-web-fragments:bitbucket.repository.nav.files': _.constant($('#file-content').length === 1 ? 'source' : 'browse'),
        'com.atlassian.bitbucket.server.bitbucket-server-web-fragments:bitbucket.repository.nav.commits': _.constant($('.commit-files').length === 1 ? 'commit' : 'commit-list'),
        'com.atlassian.bitbucket.server.bitbucket-server-web-fragments:bitbucket.repository.nav.branches': _.constant($('.branch-table').length === 1 ? 'branch-list' : 'compare'),
        'com.atlassian.bitbucket.server.bitbucket-server-web-fragments:bitbucket.repository.nav.compare': _.constant('compare'),
        'com.atlassian.bitbucket.server.bitbucket-server-web-fragments:bitbucket.repository.nav.pull-requests': _.constant($('.pull-requests-table').length === 1 ? 'pull-request-list' : 'pull-request-view'),
        'com.atlassian.bitbucket.server.bitbucket-server-web-fragments:bitbucket.repository.nav.settings': _.constant('admin'),
        'com.atlassian.bitbucket.server.bitbucket-server-web-fragments:projects-repositories-tab': _.constant('project-list'),
        'com.atlassian.bitbucket.server.bitbucket-server-web-fragments:projects-settings-tab': _.constant('admin')
    };

    return {
        getPageContext: function getPageContext() {
            var sidebarSelection = $('#aui-sidebar-content .aui-nav-selected');

            if (sidebarSelection.length === 1) {
                var webItemKey = sidebarSelection.find('a').attr('data-web-item-key');
                var webItemFunc = WEB_ITEM_KEY_MAP[webItemKey];

                return webItemFunc ? webItemFunc() : 'other';
            } else {
                return 'global';
            }
        }
    };
});