'use strict';

define('bitbucket-plugin-search/internal/component/search-urls', ['bitbucket/util/navbuilder', 'bitbucket/internal/bbui/aui-react/avatar', 'bitbucket/internal/enums'], function (nav, avatar, enums) {
    'use strict';

    var AvatarSize = enums.AvatarSize;


    return {
        commitSearchRestUrl: function commitSearchRestUrl() {
            return nav.rest('search').addPathComponents('commits').build();
        },
        commitUrl: function commitUrl(commit) {
            return nav.repository(commit.repository).commit(commit.id).build();
        },
        fileUrl: function fileUrl(repo, path, line) {
            var builder = nav.repository(repo).browse().path(path.split('/'));

            if (line) {
                builder = builder.withFragment(line);
            }

            return builder.build();
        },
        projectAvatarUrl: function projectAvatarUrl(projectKey, size) {
            return nav.project(projectKey).avatar(size).build();
        },
        searchRestUrl: function searchRestUrl() {
            return nav.rest('search').addPathComponents('search').withParams({ avatarSize: AvatarSize.MEDIUM }).build();
        }
    };
});