define('bitbucket-plugin-search/internal/feature/quick-search/components/code-search-provider', ['module', 'exports', '@atlassian/aui', 'classnames', 'react', 'bitbucket/internal/impl/urls', 'bitbucket/internal/util/i18n-html', '../../search-common/search-entities', '../constants', '../internal/analytics', './provider-common'], function (module, exports, _aui, _classnames, _react, _urls, _i18nHtml, _searchEntities, _constants, _analytics, _providerCommon) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _classnames2 = _interopRequireDefault(_classnames);

    var _react2 = _interopRequireDefault(_react);

    var _urls2 = _interopRequireDefault(_urls);

    var _i18nHtml2 = _interopRequireDefault(_i18nHtml);

    var _searchEntities2 = _interopRequireDefault(_searchEntities);

    var _analytics2 = _interopRequireDefault(_analytics);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var CodeSearchProvider = function (_AbstractQuickSearchP) {
        _inherits(CodeSearchProvider, _AbstractQuickSearchP);

        function CodeSearchProvider(onStatusUpdate, onNewItems, searchContext) {
            _classCallCheck(this, CodeSearchProvider);

            var _this = _possibleConstructorReturn(this, (CodeSearchProvider.__proto__ || Object.getPrototypeOf(CodeSearchProvider)).call(this, onStatusUpdate, onNewItems));

            _this.searchContext = searchContext;
            return _this;
        }

        _createClass(CodeSearchProvider, [{
            key: 'updateForValidQuery',
            value: function updateForValidQuery(query) {
                var _this2 = this;

                this.onNewItems([codeSearchItemData({
                    url: _urls2.default.search((this.searchContext.queryTerms + ' ' + query).trim()),
                    onClick: function onClick() {
                        return _analytics2.default.navigationClick({
                            searchContext: _this2.searchContext,
                            context: _searchEntities2.default.CODE
                        });
                    },
                    query: query,
                    title: _aui.I18n.getText('bitbucket.component.quick-search.terms', query)
                })]);
            }
        }]);

        return CodeSearchProvider;
    }(_providerCommon.AbstractQuickSearchProvider);

    exports.default = CodeSearchProvider;


    var codeSearchItemData = function codeSearchItemData(_ref) {
        var url = _ref.url,
            onClick = _ref.onClick,
            query = _ref.query,
            title = _ref.title;
        return _extends({}, _providerCommon.defaultItemProps, {
            ItemComponent: CodeSearchItem,
            id: _constants.CODE_RESULT_ID,
            props: {
                url: url,
                onClick: onClick,
                query: query,
                title: title
            }
        });
    };

    var CodeSearchItem = function CodeSearchItem(_ref2) {
        var focused = _ref2.focused,
            url = _ref2.url,
            id = _ref2.id,
            onClick = _ref2.onClick,
            query = _ref2.query,
            title = _ref2.title;

        // TODO: Figure out if we need hidden. If we do, we need to fix the results panel to pass it in (and probably implement in the other items, too)
        var hidden = false;

        return _react2.default.createElement(
            'li',
            { className: (0, _classnames2.default)('search-results-item', 'code', { focused: focused }) },
            _react2.default.createElement(
                'a',
                {
                    id: id,
                    className: (0, _classnames2.default)('code-link', { hidden: hidden }),
                    title: title || null,
                    href: url || null,
                    'aria-hidden': hidden,
                    onClick: onClick
                },
                _react2.default.createElement(
                    'div',
                    { className: 'code-search-hint', 'aria-hidden': 'true' },
                    _react2.default.createElement('span', { className: 'aui-icon aui-icon-small aui-iconfont-search' }),
                    _react2.default.createElement(
                        _i18nHtml2.default,
                        { className: 'code-search-hint-text', params: [query] },
                        _aui.I18n.getText('bitbucket.component.quick-search.terms.html', '{0}')
                    )
                )
            )
        );
    };
    module.exports = exports['default'];
});