define('bitbucket-plugin-search/internal/feature/quick-search/components/commit-provider', ['module', 'exports', '@atlassian/aui', 'classnames', 'react', 'bitbucket-plugin-search/internal/component/search-urls', 'bitbucket/internal/bbui/aui-react/avatar', 'bitbucket/internal/enums', 'bitbucket/internal/util/time', '../../search-common/analytics', '../constants', '../internal/analytics', './provider-common'], function (module, exports, _aui, _classnames, _react, _searchUrls, _avatar, _enums, _time, _analytics, _constants, _analytics2, _providerCommon) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _classnames2 = _interopRequireDefault(_classnames);

    var _react2 = _interopRequireDefault(_react);

    var _searchUrls2 = _interopRequireDefault(_searchUrls);

    var _analytics3 = _interopRequireDefault(_analytics2);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    var _get = function get(object, property, receiver) {
        if (object === null) object = Function.prototype;
        var desc = Object.getOwnPropertyDescriptor(object, property);

        if (desc === undefined) {
            var parent = Object.getPrototypeOf(object);

            if (parent === null) {
                return undefined;
            } else {
                return get(parent, property, receiver);
            }
        } else if ("value" in desc) {
            return desc.value;
        } else {
            var getter = desc.get;

            if (getter === undefined) {
                return undefined;
            }

            return getter.call(receiver);
        }
    };

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var CommitProvider = function (_AbstractRestQuickSea) {
        _inherits(CommitProvider, _AbstractRestQuickSea);

        function CommitProvider(onStatusUpdate, onNewItems, searchContext) {
            _classCallCheck(this, CommitProvider);

            var _this = _possibleConstructorReturn(this, (CommitProvider.__proto__ || Object.getPrototypeOf(CommitProvider)).call(this, onStatusUpdate, onNewItems, _constants.MIN_COMMIT_QUERY_LENGTH));

            _this.restParameters = function (query) {
                return {
                    url: _searchUrls2.default.commitSearchRestUrl(),
                    data: {
                        query: query,
                        avatarSize: _enums.AvatarSize.MEDIUM,
                        limit: _constants.MAX_QUICKSEARCH_ITEMS
                    }
                };
            };

            _this.analyticsProperties = {
                project: searchContext.project,
                repository: searchContext.repository,
                resultType: _analytics.resultType.COMMIT
            };
            return _this;
        }

        _createClass(CommitProvider, [{
            key: 'queryIsValid',
            value: function queryIsValid() {
                var query = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';

                query = query.trim();

                // Ensure the trimmed query is long enough (using the super method) and all hexidecimal characters
                return _get(CommitProvider.prototype.__proto__ || Object.getPrototypeOf(CommitProvider.prototype), 'queryIsValid', this).call(this, query) && /^[0-9a-f]+$/i.test(query);
            }
        }, {
            key: 'onResponse',
            value: function onResponse(_ref) {
                var _this2 = this;

                var query = _ref.query,
                    requestDuration = _ref.requestDuration,
                    response = _ref.response;

                var commits = response.values;
                var numCommits = commits.length;

                _analytics3.default.resultsLoaded(_extends({}, this.analyticsProperties, {
                    time: requestDuration,
                    query: query,
                    numResults: numCommits
                }));

                var commitItems = [];

                if (numCommits > 0) {
                    commitItems.push((0, _providerCommon.headerItemData)({
                        headerShortKey: 'commits',
                        headerText: _aui.I18n.getText('bitbucket.component.quick-search.section.commits')
                    }));

                    commitItems = commitItems.concat(commits.map(function (commit, index) {
                        return commitItemData({
                            commit: commit,
                            onClick: function onClick() {
                                return _analytics3.default.resultClicked(_extends({}, _this2.analyticsProperties, {
                                    index: index
                                }));
                            },
                            url: _searchUrls2.default.commitUrl(commit),
                            repository: commit.repository
                        });
                    }));
                }
                this.onNewItems(commitItems);
            }
        }]);

        return CommitProvider;
    }(_providerCommon.AbstractRestQuickSearchProvider);

    exports.default = CommitProvider;


    var commitItemData = function commitItemData(_ref2) {
        var commit = _ref2.commit,
            url = _ref2.url,
            onClick = _ref2.onClick,
            repository = _ref2.repository;
        return _extends({}, _providerCommon.defaultItemProps, {
            ItemComponent: CommitItem,
            id: 'quick-search-commit-' + repository.id + '-' + commit.id,
            props: {
                commit: commit,
                url: url,
                onClick: onClick,
                repository: repository
            }
        });
    };

    var truncateFirstLineOnly = function truncateFirstLineOnly(message) {
        message = message.split('\n')[0];

        return message.length <= _constants.MAX_COMMIT_MESSAGE_LENGTH ? message : message.slice(0, _constants.MAX_COMMIT_MESSAGE_LENGTH) + '…';
    };

    var CommitItem = function CommitItem(_ref3) {
        var commit = _ref3.commit,
            focused = _ref3.focused,
            url = _ref3.url,
            id = _ref3.id,
            onClick = _ref3.onClick,
            repository = _ref3.repository;

        return _react2.default.createElement(
            'li',
            { className: (0, _classnames2.default)('search-results-item', 'commit', { focused: focused }) },
            _react2.default.createElement(
                'a',
                {
                    href: url,
                    className: 'commit-link',
                    'data-entity': 'commit',
                    'data-commit-id': commit.id,
                    id: id,
                    title: commit.id.slice(0, _constants.COMMIT_HASH_LENGTH) + ' - ' + truncateFirstLineOnly(commit.message),
                    onClick: onClick
                },
                _react2.default.createElement(_avatar.UserAvatar, { person: commit.author, size: 'medium' }),
                _react2.default.createElement(
                    'div',
                    { className: 'item-wrapper' },
                    _react2.default.createElement(
                        'strong',
                        { className: 'item-name' },
                        _react2.default.createElement(
                            'span',
                            null,
                            commit.message.split('\n')[0]
                        )
                    ),
                    _react2.default.createElement(
                        'p',
                        { className: 'item-description' },
                        _react2.default.createElement(
                            'span',
                            null,
                            commit.author.name,
                            _react2.default.createElement(Separator, null),
                            repository.name,
                            _react2.default.createElement(Separator, null),
                            _react2.default.createElement(
                                'time',
                                { dateTime: (0, _time.format)(commit.authorTimestamp, 'timestamp') },
                                (0, _time.format)(commit.authorTimestamp, 'shortAge')
                            )
                        )
                    )
                )
            )
        );
    };

    var Separator = function Separator() {
        return _react2.default.createElement(
            'span',
            null,
            ' \xB7 '
        );
    };
    module.exports = exports['default'];
});