define('bitbucket-plugin-search/internal/feature/quick-search/components/provider-common', ['exports', 'lodash', 'react', 'bitbucket/internal/bbui/javascript-errors/javascript-errors', 'bitbucket/internal/impl/request', '../constants', '../request-status'], function (exports, _lodash, _react, _javascriptErrors, _request, _constants, _requestStatus) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.headerItemData = exports.defaultItemProps = exports.AbstractRestQuickSearchProvider = exports.AbstractQuickSearchProvider = undefined;

    var _react2 = _interopRequireDefault(_react);

    var _javascriptErrors2 = _interopRequireDefault(_javascriptErrors);

    var _request2 = _interopRequireDefault(_request);

    var RequestStatus = _interopRequireWildcard(_requestStatus);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    var AbstractQuickSearchProvider = exports.AbstractQuickSearchProvider = function () {
        function AbstractQuickSearchProvider(onStatusUpdate, onNewItems) {
            var minQueryLength = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : _constants.DEFAULT_MIN_QUERY_LENGTH;

            _classCallCheck(this, AbstractQuickSearchProvider);

            this.onStatusUpdate = onStatusUpdate;
            this.onNewItems = onNewItems;
            this.minQueryLength = minQueryLength;
        }

        /**
         * Check if the query is valid. The default implementation checks the query's length.
         *
         * @param {string} query - the query to validate
         * @returns {boolean} true if the query is valid and we should produce new items
         */


        _createClass(AbstractQuickSearchProvider, [{
            key: 'queryIsValid',
            value: function queryIsValid(query) {
                return query.length >= this.minQueryLength;
            }

            /**
             * Called when the query changes and is valid. Subclasses should override
             * this method to generate a list of items and call onStatusUpdate/onNewItems
             * as appropriate.
             *
             * @param {string} query - the new query
             */

        }, {
            key: 'updateForValidQuery',
            value: function updateForValidQuery(query) {
                throw new _javascriptErrors2.default.NotImplementedError('updateForValidQuery is abstract and must be implemented.');
            }

            /**
             * Called whenever the query changes. Checks if the query is valid and - if so -
             * generates an updated list of items. Subclasses should not need to override this method.
             *
             * @param {string} query - the new query
             */

        }, {
            key: 'updateQuery',
            value: function updateQuery(query) {
                if (!this.queryIsValid(query)) {
                    this.onStatusUpdate(RequestStatus.OK);
                    this.onNewItems([]);
                } else {
                    this.updateForValidQuery(query);
                }
            }
        }]);

        return AbstractQuickSearchProvider;
    }();

    var AbstractRestQuickSearchProvider = exports.AbstractRestQuickSearchProvider = function (_AbstractQuickSearchP) {
        _inherits(AbstractRestQuickSearchProvider, _AbstractQuickSearchP);

        function AbstractRestQuickSearchProvider() {
            var _ref;

            var _temp, _this, _ret;

            _classCallCheck(this, AbstractRestQuickSearchProvider);

            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                args[_key] = arguments[_key];
            }

            return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = AbstractRestQuickSearchProvider.__proto__ || Object.getPrototypeOf(AbstractRestQuickSearchProvider)).call.apply(_ref, [this].concat(args))), _this), _this.doSearch = (0, _lodash.debounce)(function (query) {
                var startTime = Date.now();

                _this.currentSearchRequest = _request2.default.rest(_extends({
                    statusCode: {
                        '*': false
                    }
                }, _this.restParameters(query))).done(function (response) {
                    _this.onStatusUpdate(RequestStatus.OK);

                    _this.onResponse({
                        query: query,
                        requestDuration: Date.now() - startTime,
                        response: response
                    });
                }).fail(function (xhr, textStatus) {
                    if (textStatus !== 'abort') {
                        _this.onStatusUpdate(RequestStatus.ERROR);
                    }
                }).always(function () {
                    _this.currentSearchRequest = null;
                });
            }, _constants.QUICKSEARCH_DEBOUNCE_TIMEOUT), _temp), _possibleConstructorReturn(_this, _ret);
        }

        _createClass(AbstractRestQuickSearchProvider, [{
            key: 'restParameters',


            /**
             * Provides the REST call parameters. Subclasses must override.
             *
             * @param {string} query - the query to generate a REST request for
             * @return {Object} parameters for a request.rest call
             */
            value: function restParameters(query) {
                throw new _javascriptErrors2.default.NotImplementedError('restParameters is abstract and must be implemented.');
            }

            /**
             * Called when the REST call completes successfully. Subclasses must override.
             *
             * @param {Object} data - the response body
             * @param {string} data.query - the query used to generate the data
             * @param {number} data.requestDuration - how long the request took
             * @param {Object} data.response - the response object
             */

        }, {
            key: 'onResponse',
            value: function onResponse(data) {
                throw new _javascriptErrors2.default.NotImplementedError('onResponse is abstract and must be implemented.');
            }
        }, {
            key: 'updateForValidQuery',
            value: function updateForValidQuery(query) {
                // set status aggressively (i.e. ahead of the debounced repo search),
                // so we can rely on status to show/hide elements elsewhere (e.g. ResultsPanel) without visual glitches.
                this.onStatusUpdate(RequestStatus.WAITING);
                this.onNewItems([]);

                // always abort the current search request before calling the debounced search to avoid
                // issues where an inflight result would finish after the UI had been prepared for a
                // different result
                if (this.currentSearchRequest && this.currentSearchRequest.abort) {
                    this.currentSearchRequest.abort();
                    this.currentSearchRequest = null;
                }

                this.doSearch(query);
            }
        }]);

        return AbstractRestQuickSearchProvider;
    }(AbstractQuickSearchProvider);

    var defaultItemProps = exports.defaultItemProps = {
        selectable: true
    };

    // Due to how I18n.getText works (server-side) we have to pass the header text in, not the header I18n key
    var headerItemData = exports.headerItemData = function headerItemData(_ref2) {
        var headerShortKey = _ref2.headerShortKey,
            headerText = _ref2.headerText;
        return _extends({}, defaultItemProps, {
            ItemComponent: HeaderItem,
            id: 'quick-search-header-' + headerShortKey,
            selectable: false,
            props: {
                headerText: headerText
            }
        });
    };

    var HeaderItem = function HeaderItem(_ref3) {
        var headerText = _ref3.headerText,
            id = _ref3.id;

        return _react2.default.createElement(
            'li',
            { id: id, className: 'repository-heading' },
            _react2.default.createElement(
                'h2',
                { className: 'section-title' },
                headerText
            )
        );
    };
});