define('bitbucket-plugin-search/internal/feature/quick-search/components/repository-provider', ['module', 'exports', '@atlassian/aui', 'classnames', 'react', 'bitbucket-plugin-search/internal/component/search-urls', 'bitbucket/internal/feature/repository/search-results/search-results-item', 'bitbucket/internal/impl/urls', 'bitbucket/internal/util/text', '../../search-common/analytics', '../../search-common/search-entities', '../../search-common/search-request', '../constants', '../internal/analytics', '../navigation-item-context', './provider-common'], function (module, exports, _aui, _classnames, _react, _searchUrls, _searchResultsItem, _urls, _text, _analytics, _searchEntities, _searchRequest, _constants, _analytics2, _navigationItemContext, _providerCommon) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _classnames2 = _interopRequireDefault(_classnames);

    var _react2 = _interopRequireDefault(_react);

    var _searchUrls2 = _interopRequireDefault(_searchUrls);

    var _searchResultsItem2 = _interopRequireDefault(_searchResultsItem);

    var _urls2 = _interopRequireDefault(_urls);

    var _searchEntities2 = _interopRequireDefault(_searchEntities);

    var _analytics3 = _interopRequireDefault(_analytics2);

    var NavigationItemContext = _interopRequireWildcard(_navigationItemContext);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var RepositoryProvider = function (_AbstractRestQuickSea) {
        _inherits(RepositoryProvider, _AbstractRestQuickSea);

        function RepositoryProvider(onStatusUpdate, onNewItems, searchContext) {
            _classCallCheck(this, RepositoryProvider);

            var _this = _possibleConstructorReturn(this, (RepositoryProvider.__proto__ || Object.getPrototypeOf(RepositoryProvider)).call(this, onStatusUpdate, onNewItems));

            _this.restParameters = function (query) {
                return {
                    type: 'POST',
                    url: _searchUrls2.default.searchRestUrl(),
                    data: (0, _searchRequest.searchFor)(query, [_searchEntities2.default.REPOSITORIES], {
                        primary: _constants.MAX_QUICKSEARCH_ITEMS
                    })
                };
            };

            _this.searchContext = searchContext;
            _this.analyticsProperties = {
                project: _this.searchContext.project,
                repository: _this.searchContext.repository,
                resultType: _analytics.resultType.REPOSITORY
            };
            return _this;
        }

        _createClass(RepositoryProvider, [{
            key: 'onResponse',
            value: function onResponse(_ref) {
                var _this2 = this;

                var query = _ref.query,
                    requestDuration = _ref.requestDuration,
                    response = _ref.response;
                var repositories = response.repositories;

                var totalRepoCount = repositories.count;

                _analytics3.default.resultsLoaded(_extends({}, this.analyticsProperties, {
                    time: requestDuration,
                    query: query,
                    numResults: totalRepoCount
                }));

                var numRepos = repositories.values.length;
                var repoItems = [];

                if (numRepos > 0) {
                    repoItems.push((0, _providerCommon.headerItemData)({
                        headerShortKey: 'repositories',
                        headerText: _aui.I18n.getText('bitbucket.component.quick-search.section.repositories')
                    }));

                    repoItems = repoItems.concat(repositories.values.map(function (repository, index) {
                        return repositoryItemData({
                            onClick: function onClick() {
                                return _analytics3.default.resultClicked(_extends({}, _this2.analyticsProperties, {
                                    clickedRepository: repository,
                                    index: index
                                }));
                            },
                            query: query,
                            repository: repository
                        });
                    }));

                    if (totalRepoCount > numRepos) {
                        repoItems.push(showMoreRepositoriesItemData({
                            url: _urls2.default.search(query),
                            onClick: function onClick() {
                                return _analytics3.default.navigationClick({
                                    searchContext: _this2.searchContext,
                                    context: NavigationItemContext.SHOW_MORE_REPOS
                                });
                            },
                            totalRepoCount: totalRepoCount
                        }));
                    }
                }
                this.onNewItems(repoItems);
            }
        }]);

        return RepositoryProvider;
    }(_providerCommon.AbstractRestQuickSearchProvider);

    exports.default = RepositoryProvider;


    var repositoryItemData = function repositoryItemData(_ref2) {
        var onClick = _ref2.onClick,
            query = _ref2.query,
            repository = _ref2.repository;
        return _extends({}, _providerCommon.defaultItemProps, {
            // SearchResultsItem is defined in core
            ItemComponent: _searchResultsItem2.default,
            id: 'quick-search-repository-' + repository.id,
            props: {
                // SearchResultsItem wants onItemClick instead of onClick like the rest of the quick search Components so...
                onItemClick: onClick,
                query: query,
                repository: repository
            }
        });
    };

    var showMoreRepositoriesItemData = function showMoreRepositoriesItemData(_ref3) {
        var url = _ref3.url,
            onClick = _ref3.onClick,
            totalRepoCount = _ref3.totalRepoCount;
        return _extends({}, _providerCommon.defaultItemProps, {
            ItemComponent: ShowMoreRepositoriesItem,
            id: _constants.REPO_RESULT_COUNT_ID,
            props: {
                url: url,
                onClick: onClick,
                totalRepoCount: totalRepoCount
            }
        });
    };

    var ShowMoreRepositoriesItem = function ShowMoreRepositoriesItem(_ref4) {
        var focused = _ref4.focused,
            url = _ref4.url,
            id = _ref4.id,
            onClick = _ref4.onClick,
            totalRepoCount = _ref4.totalRepoCount;

        return _react2.default.createElement(
            'li',
            { className: (0, _classnames2.default)('search-results-item', 'count', { focused: focused }) },
            _react2.default.createElement(
                'a',
                { id: id, href: url, onClick: onClick },
                _react2.default.createElement('span', { className: 'aui-icon icon-repository' }),
                _react2.default.createElement('div', {
                    dangerouslySetInnerHTML: {
                        __html: _aui.I18n.getText('bitbucket.component.quick-search.show.repositories', (0, _text.capInt)(totalRepoCount, _constants.MAX_REPO_COUNT))
                    }
                })
            )
        );
    };
    module.exports = exports['default'];
});