define('bitbucket-plugin-search/internal/feature/quick-search/components/results-panel', ['module', 'exports', '@atlassian/aui', 'prop-types', 'react', '../request-status'], function (module, exports, _aui, _propTypes, _react, _requestStatus) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var RepoSearchErrors = function RepoSearchErrors() {
        return _react2.default.createElement(
            'div',
            { className: 'quick-search-error' },
            _react2.default.createElement(
                'div',
                { className: 'content' },
                _react2.default.createElement('div', { className: 'warning-icon' }),
                _react2.default.createElement(
                    'div',
                    { className: 'error-text' },
                    _react2.default.createElement(
                        'div',
                        { className: 'error-text-primary' },
                        _aui.I18n.getText('bitbucket.component.quick-search.error.primary')
                    ),
                    _react2.default.createElement(
                        'div',
                        { className: 'error-text-secondary' },
                        _aui.I18n.getText('bitbucket.component.quick-search.error.secondary')
                    )
                )
            ),
            _react2.default.createElement(
                'div',
                { className: 'footer' },
                _aui.I18n.getText('bitbucket.component.quick-search.error.troubleshoot')
            )
        );
    };

    // Replacement for BBPanel
    // Keeping it internal here in hopes we someday can just kill it in favor of an AtlasKit component.

    var Panel = function (_Component) {
        _inherits(Panel, _Component);

        function Panel() {
            var _ref;

            var _temp, _this, _ret;

            _classCallCheck(this, Panel);

            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                args[_key] = arguments[_key];
            }

            return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = Panel.__proto__ || Object.getPrototypeOf(Panel)).call.apply(_ref, [this].concat(args))), _this), _this.position = _this.props.expanded && _this.getPosition() || { x: null, y: null }, _this.layerUpdateNeeded = false, _this.externalLayerHide = false, _this.onResize = function () {
                if (_this.props.expanded) {
                    _this.updatePosition();
                }
            }, _this.onRef = function (el) {
                _this.ref = el;
                _this.ref.addEventListener('aui-hide', function () {
                    _this.externalLayerHide = true;
                    _this.props.onHide();
                });
                _this.layerUpdateNeeded = true;
            }, _temp), _possibleConstructorReturn(_this, _ret);
        }

        _createClass(Panel, [{
            key: 'componentDidMount',
            value: function componentDidMount() {
                if (this.props.expanded && this.ref) {
                    (0, _aui.layer)(this.ref).show();
                    this.layerUpdateNeeded = false;
                }
                window.addEventListener('resize', this.onResize);
            }
        }, {
            key: 'componentDidUpdate',
            value: function componentDidUpdate(prevProps) {
                if (this.props.expanded && (!prevProps.expanded || this.position.x === null || this.props.anchorTo !== prevProps.anchorTo)) {
                    this.updatePosition();
                }

                if (this.ref) {
                    if (this.props.expanded && (!prevProps.expanded || this.layerUpdateNeeded)) {
                        (0, _aui.layer)(this.ref).show();
                        this.layerUpdateNeeded = false;
                        this.externalLayerHide = false;
                    } else if (!this.props.expanded && prevProps.expanded) {
                        if (!this.externalLayerHide) {
                            (0, _aui.layer)(this.ref).hide();
                        }
                        this.layerUpdateNeeded = false;
                        this.externalLayerHide = false;
                    }
                }
            }
        }, {
            key: 'componentWillUnmount',
            value: function componentWillUnmount() {
                window.removeEventListener('resize', this.onResize);
                if (this.ref && this.props.expanded) {
                    (0, _aui.layer)(this.ref).hide();
                }
            }
        }, {
            key: 'getPosition',
            value: function getPosition() {
                if (this.props.anchorTo) {
                    var anchor = document.getElementById(this.props.anchorTo);

                    var _anchor$getBoundingCl = anchor.getBoundingClientRect(),
                        bottom = _anchor$getBoundingCl.bottom,
                        left = _anchor$getBoundingCl.left;

                    return {
                        y: Math.floor(bottom + window.pageYOffset - document.documentElement.clientTop),
                        x: Math.floor(left + window.pageXOffset - document.documentElement.clientLeft)
                    };
                }
            }
        }, {
            key: 'updatePosition',
            value: function updatePosition() {
                var position = this.getPosition();

                if (position && (position.x !== this.position.x || position.y !== this.position.y)) {
                    this.position = position;
                }
            }
        }, {
            key: 'render',
            value: function render() {
                if (this.position.x == null) {
                    return null;
                }

                var _props = this.props,
                    children = _props.children,
                    domContainer = _props.domContainer,
                    expanded = _props.expanded,
                    id = _props.id;

                var style = {
                    left: 0,
                    top: 0,
                    position: 'absolute',
                    transform: 'translate3d(10px, 30px, 0px)'
                };

                return _react2.default.createElement(
                    'div',
                    {
                        id: id,
                        ref: this.onRef,
                        className: 'aui-layer',
                        style: style,
                        'aria-hidden': !expanded,
                        'data-aui-dom-container': domContainer
                    },
                    children
                );
            }
        }]);

        return Panel;
    }(_react.Component);

    Panel.propTypes = {
        anchorTo: _propTypes2.default.string,
        domContainer: _propTypes2.default.string.isRequired,
        expanded: _propTypes2.default.bool.isRequired,
        onHide: _propTypes2.default.func.isRequired,
        children: _propTypes2.default.node.isRequired,
        id: _propTypes2.default.string
    };


    var ResultsPanel = function ResultsPanel(_ref2) {
        var focusedIndex = _ref2.focusedIndex,
            status = _ref2.status,
            items = _ref2.items,
            _ref2$expanded = _ref2.expanded,
            expanded = _ref2$expanded === undefined ? false : _ref2$expanded,
            onHide = _ref2.onHide;

        var showErrors = status === _requestStatus.ERROR;

        return _react2.default.createElement(
            Panel,
            {
                id: 'quick-search-dialog',
                anchorTo: 'quick-search',
                domContainer: '#quick-search-loader',
                onHide: onHide,
                expanded: expanded
            },
            showErrors && _react2.default.createElement(RepoSearchErrors, null),
            !showErrors && _react2.default.createElement(
                'div',
                { className: 'quick-search-main repository-list-container' },
                _react2.default.createElement(
                    'ul',
                    {
                        id: 'quick-search-results',
                        className: 'quick-search-results repository-list search-results-container',
                        role: 'presentation'
                    },
                    items.map(function (_ref3, index) {
                        var ItemComponent = _ref3.ItemComponent,
                            id = _ref3.id,
                            props = _ref3.props;
                        return _react2.default.createElement(ItemComponent, _extends({}, props, {
                            id: id,
                            key: id,
                            focused: focusedIndex === index
                        }));
                    })
                )
            )
        );
    };
    ResultsPanel.propTypes = {
        expanded: _propTypes2.default.bool.isRequired,
        focusedIndex: _propTypes2.default.number.isRequired,
        items: _propTypes2.default.array.isRequired,
        status: _propTypes2.default.string.isRequired,
        onHide: _propTypes2.default.func.isRequired
    };

    exports.default = ResultsPanel;
    module.exports = exports['default'];
});