define('bitbucket-plugin-search/internal/feature/quick-search/components/search-form', ['module', 'exports', '@atlassian/aui', 'classnames', 'react', 'bitbucket/internal/bbui/aui-react/spinner', 'bitbucket/internal/util/shortcuts', '../request-status'], function (module, exports, _aui, _classnames, _react, _spinner, _shortcuts, _requestStatus) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _classnames2 = _interopRequireDefault(_classnames);

    var _react2 = _interopRequireDefault(_react);

    var _spinner2 = _interopRequireDefault(_spinner);

    var shortcuts = _interopRequireWildcard(_shortcuts);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var SearchForm = function (_React$Component) {
        _inherits(SearchForm, _React$Component);

        function SearchForm() {
            _classCallCheck(this, SearchForm);

            return _possibleConstructorReturn(this, (SearchForm.__proto__ || Object.getPrototypeOf(SearchForm)).apply(this, arguments));
        }

        _createClass(SearchForm, [{
            key: 'componentDidMount',
            value: function componentDidMount() {
                var _this2 = this;

                shortcuts.bind('focusQuickSearch', function () {
                    return _this2.inputElement.focus();
                });
            }
        }, {
            key: 'render',
            value: function render() {
                var _this3 = this;

                var _props = this.props,
                    searchUrl = _props.searchUrl,
                    onKeyDown = _props.onKeyDown,
                    onChange = _props.onChange,
                    onKeyUp = _props.onKeyUp,
                    status = _props.status,
                    activeDescendant = _props.activeDescendant,
                    expanded = _props.expanded,
                    onFocus = _props.onFocus;

                var waiting = status === _requestStatus.WAITING;

                return _react2.default.createElement(
                    'form',
                    {
                        className: (0, _classnames2.default)('aui-quicksearch', { loading: waiting }),
                        method: 'GET',
                        action: searchUrl,
                        onSubmit: function onSubmit(e) {
                            return e.preventDefault();
                        }
                    },
                    _react2.default.createElement(
                        'div',
                        { className: 'quick-search-trigger' },
                        _react2.default.createElement(
                            'label',
                            { className: 'assistive', htmlFor: 'quick-search' },
                            _aui.I18n.getText('bitbucket.component.quick-search.label')
                        ),
                        _react2.default.createElement('input', {
                            id: 'quick-search',
                            name: 'q',
                            type: 'text',
                            autoComplete: 'off',
                            placeholder: _aui.I18n.getText('bitbucket.component.quick-search.placeholder'),
                            'aria-activedescendant': activeDescendant,
                            'aria-autocomplete': 'both',
                            'aria-busy': waiting,
                            'aria-controls': 'quick-search-dialog',
                            'aria-expanded': expanded,
                            'aria-haspopup': true,
                            role: 'combobox',
                            onKeyDown: onKeyDown,
                            onKeyUp: onKeyUp,
                            onChange: onChange,
                            onFocus: onFocus,
                            ref: function ref(el) {
                                return _this3.inputElement = el;
                            }
                        }),
                        waiting ? _react2.default.createElement(_spinner2.default, { size: 'small' }) : null
                    )
                );
            }
        }]);

        return SearchForm;
    }(_react2.default.Component);

    exports.default = SearchForm;
    module.exports = exports['default'];
});