define('bitbucket-plugin-search/internal/feature/quick-search/internal/analytics', ['module', 'exports', 'bitbucket-plugin-search/internal/component/search-analytics-utils', 'bitbucket/internal/impl/analytics', '../../search-common/analytics'], function (module, exports, _searchAnalyticsUtils, _analytics, _analytics3) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _searchAnalyticsUtils2 = _interopRequireDefault(_searchAnalyticsUtils);

    var _analytics2 = _interopRequireDefault(_analytics);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    function commonAttributes(project, repository) {
        var attributes = {
            context: _searchAnalyticsUtils2.default.getPageContext()
        };

        if (repository) {
            attributes['repository.id'] = repository.id;
        }
        if (project) {
            attributes['project.id'] = project.id;
        }

        return attributes;
    }

    exports.default = {
        /**
         * @param {Object} options - Options for this event
         * @param {Object?} options.repository - Optional repository
         * @param {Object?} options.project - Optional project
         */
        focused: function focused(options) {
            var attributes = commonAttributes(options.project, options.repository);
            _analytics2.default.trigger('bitbucket.ui.quick-search.focused', attributes);
        },


        /**
         * @param {Object} options - Options for this event
         * @param {Object?} options.repository - Optional repository
         * @param {Object?} options.project - Optional project
         * @param {string} options.query - The search query
         * @param {number} options.numResults - The total number of results found for the query
         * @param {string} options.resultType - The type of quicksearch results: 'repository' or 'commit'
         * @param {number} options.time - The search timing
         */
        resultsLoaded: function resultsLoaded(options) {
            var attributes = _extends({
                time: options.time,
                // repositories.count replaced with result.count in BbS 5.8 - get rid of this when we don't need the older analytics
                'repositories.count': options.numResults,
                'result.count': options.numResults,
                'result.type': options.resultType
            }, (0, _analytics3.queryAttributes)(options.query), commonAttributes(options.project, options.repository));

            _analytics2.default.trigger('bitbucket.ui.quick-search.results.loaded', attributes);
        },


        /**
         * @param {Object} options - the options for this event
         * @param {Object?} options.repository - optional repository
         * @param {Object?} options.project - optional project
         * @param {number} options.clickedRepository - Clicked repository (if applicable)
         * @param {number} options.index - the index of the clicked repository
         * @param {string} options.resultType - The type of quicksearch results: 'repository' or 'commit'
         */
        resultClicked: function resultClicked(options) {
            var attributes = _extends({
                'clicked.index': options.index
            }, options.clickedRepository ? {
                'clicked.project.id': options.clickedRepository.project.id,
                'clicked.repository.id': options.clickedRepository.id
            } : {}, commonAttributes(options.project, options.repository), {
                // repository.index replaced with clicked.index in BbS 5.8 - get rid of this when we don't need the older analytics
                'repository.index': options.index,
                'result.type': options.resultType
            });

            _analytics2.default.trigger('bitbucket.ui.quick-search.result.clicked', attributes);
        },


        /**
         * This should be triggered for non-result items that are clicked in the quick search dialog
         * @param {Object} options - the options for this event
         * @param {SearchContext} options.searchContext - the SearchContext for this event
         * @param {string} options.context - context of the link that was clicked
         */
        navigationClick: function navigationClick(options) {
            var attributes = _extends({}, commonAttributes(options.searchContext.project, options.searchContext.repository), {
                context: options.context
            });

            _analytics2.default.trigger('bitbucket.ui.quick-search.navigation.clicked', attributes);
        }
    };
    module.exports = exports['default'];
});