define('bitbucket-plugin-search/internal/feature/quick-search/internal/search-context', ['module', 'exports'], function (module, exports) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    var SearchContext = function () {
        function SearchContext(project, repository) {
            _classCallCheck(this, SearchContext);

            this.project = project;
            this.repository = repository;
        }

        _createClass(SearchContext, [{
            key: 'queryTerms',
            get: function get() {
                if (this.repository) {
                    return 'project:' + this.project.key + ' repo:' + this.repository.slug;
                } else if (this.project) {
                    return 'project:' + this.project.key;
                }

                return '';
            }
        }]);

        return SearchContext;
    }();

    exports.default = SearchContext;
    module.exports = exports['default'];
});