define('bitbucket-plugin-search/internal/feature/quick-search/quick-search', ['exports', '@atlassian/aui', 'lodash', 'prop-types', 'react', 'bitbucket/internal/impl/urls', './components/code-search-provider', './components/commit-provider', './components/repository-provider', './components/results-panel', './components/search-form', './constants', './internal/analytics', './internal/search-context', './request-status'], function (exports, _aui, _lodash, _propTypes, _react, _urls, _codeSearchProvider, _commitProvider, _repositoryProvider, _resultsPanel, _searchForm, _constants, _analytics, _searchContext, _requestStatus) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.calculateNextFocusedIndex = calculateNextFocusedIndex;

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    var _urls2 = _interopRequireDefault(_urls);

    var _codeSearchProvider2 = _interopRequireDefault(_codeSearchProvider);

    var _commitProvider2 = _interopRequireDefault(_commitProvider);

    var _repositoryProvider2 = _interopRequireDefault(_repositoryProvider);

    var _resultsPanel2 = _interopRequireDefault(_resultsPanel);

    var _searchForm2 = _interopRequireDefault(_searchForm);

    var _analytics2 = _interopRequireDefault(_analytics);

    var _searchContext2 = _interopRequireDefault(_searchContext);

    var RequestStatus = _interopRequireWildcard(_requestStatus);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    function _toConsumableArray(arr) {
        if (Array.isArray(arr)) {
            for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
                arr2[i] = arr[i];
            }

            return arr2;
        } else {
            return Array.from(arr);
        }
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var QuickSearch = function (_PureComponent) {
        _inherits(QuickSearch, _PureComponent);

        function QuickSearch(props) {
            _classCallCheck(this, QuickSearch);

            var _this = _possibleConstructorReturn(this, (QuickSearch.__proto__ || Object.getPrototypeOf(QuickSearch)).call(this, props));

            _this.onNewItems = function (providerIndex, items) {
                _this.onProviderUpdate(providerIndex, 'items', items);
            };

            _this.onStatusUpdate = function (providerIndex, status) {
                _this.onProviderUpdate(providerIndex, 'status', status);
            };

            _this.onProviderUpdate = function (providerIndex, stateKey, value) {
                _this.setState(function (_ref) {
                    var prevStateArray = _ref[stateKey];

                    // shallow copy the original provider array
                    var newStateArray = [].concat(_toConsumableArray(prevStateArray));

                    // update with the value the provider gave us
                    newStateArray[providerIndex] = value;

                    // and then return the updated status
                    return _defineProperty({}, stateKey, newStateArray);
                });
            };

            _this.onChange = function (e) {
                var newQuery = e.target.value;

                _this.setState(function (state) {
                    var changes = { query: newQuery };

                    if (state.query !== newQuery) {
                        // reset the focused element when the search terms change
                        changes.focusedIndex = 0;
                    }

                    return changes;
                }, function () {
                    _this.providers.forEach(function (provider) {
                        return provider.updateQuery(_this.state.query);
                    });
                });

                _this._updatePanel(newQuery.length >= _constants.DEFAULT_MIN_QUERY_LENGTH);
            };

            _this.onKeyDown = function (e) {
                if (e.keyCode === _aui.keyCode.DOWN || e.keyCode === _aui.keyCode.UP) {
                    e.preventDefault();
                    // React warns if I send the actual event - so just send whether the key was down or up
                    _this._handleUpAndDownKeys(e.keyCode === _aui.keyCode.UP);
                } else if (e.keyCode === _aui.keyCode.ENTER) {
                    e.preventDefault();
                    e.nativeEvent.stopImmediatePropagation();

                    var _this$state = _this.state,
                        focusedIndex = _this$state.focusedIndex,
                        items = _this$state.items;

                    var selectedItem = (0, _lodash.flatten)(items)[focusedIndex];

                    if (selectedItem) {
                        document.getElementById(selectedItem.id).click();
                    }
                } else if (e.keyCode === _aui.keyCode.ESCAPE) {
                    e.preventDefault();
                    e.target && e.target.blur();

                    _this.setState({
                        panelOpen: false
                    });
                }
            };

            _this._handleUpAndDownKeys = function (isUp) {
                _this.setState(function (_ref3) {
                    var focusedIndex = _ref3.focusedIndex,
                        items = _ref3.items;
                    return {
                        focusedIndex: calculateNextFocusedIndex((0, _lodash.flatten)(items), focusedIndex, isUp)
                    };
                });
            };

            var searchContext = new _searchContext2.default(_this.props.project, _this.props.repository);

            // it's critical that each provider knows which item in the `items` and `status` arrays to update
            // so we map from function -> provider to auto-set them
            _this.providers = [function (providerIndex) {
                return new _codeSearchProvider2.default(function (status) {
                    return _this.onStatusUpdate(providerIndex, status);
                }, function (items) {
                    return _this.onNewItems(providerIndex, items);
                }, searchContext);
            }, function (providerIndex) {
                return new _commitProvider2.default(function (status) {
                    return _this.onStatusUpdate(providerIndex, status);
                }, function (items) {
                    return _this.onNewItems(providerIndex, items);
                }, searchContext);
            }, function (providerIndex) {
                return new _repositoryProvider2.default(function (status) {
                    return _this.onStatusUpdate(providerIndex, status);
                }, function (items) {
                    return _this.onNewItems(providerIndex, items);
                }, searchContext);
            }].map(function (cb, index) {
                return cb(index);
            });

            _this.state = {
                focusedIndex: 0,
                panelOpen: false,
                currentSearchTerms: '',
                items: _this.providers.map(function () {
                    return [];
                }),
                status: _this.providers.map(function () {
                    return RequestStatus.OK;
                })
            };
            return _this;
        }

        // Used by the providers to update items in the list

        // Used by the providers to update status


        _createClass(QuickSearch, [{
            key: '_updatePanel',
            value: function _updatePanel(open) {
                this.setState(function (_ref4) {
                    var _ref4$query = _ref4.query,
                        query = _ref4$query === undefined ? '' : _ref4$query,
                        currentSearchTerms = _ref4.currentSearchTerms;

                    var newState = {
                        currentSearchTerms: query,
                        panelOpen: open
                    };

                    if (open && currentSearchTerms !== query) {
                        newState.repos = null;
                        newState.totalRepoCount = 0;
                    }

                    return newState;
                });
            }
        }, {
            key: '_onFocus',
            value: function _onFocus() {
                var currentSearchTerms = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
                var _props = this.props,
                    project = _props.project,
                    repository = _props.repository;

                this._updatePanel(currentSearchTerms.length >= _constants.DEFAULT_MIN_QUERY_LENGTH);

                _analytics2.default.focused({
                    project: project,
                    repository: repository
                });
            }
        }, {
            key: 'render',
            value: function render() {
                var _this2 = this;

                var _state = this.state,
                    currentSearchTerms = _state.currentSearchTerms,
                    focusedIndex = _state.focusedIndex,
                    panelOpen = _state.panelOpen,
                    items = _state.items,
                    status = _state.status;


                var statusSummary = status.reduce(function (acc, curr) {
                    if (acc === RequestStatus.ERROR || curr === RequestStatus.ERROR) {
                        return RequestStatus.ERROR;
                    } else if (acc === RequestStatus.WAITING || curr === RequestStatus.WAITING) {
                        return RequestStatus.WAITING;
                    } else {
                        return RequestStatus.OK;
                    }
                }, RequestStatus.OK);

                var flattenedItems = (0, _lodash.flatten)(items);
                var selectedItem = flattenedItems[focusedIndex];

                var activeDescendant = '';

                if (selectedItem) {
                    activeDescendant = selectedItem.id;
                }

                return _react2.default.createElement(
                    'div',
                    null,
                    _react2.default.createElement(_searchForm2.default, {
                        activeDescendant: panelOpen ? activeDescendant : '',
                        expanded: panelOpen,
                        onChange: this.onChange,
                        onFocus: function onFocus() {
                            return _this2._onFocus(currentSearchTerms);
                        },
                        onKeyDown: this.onKeyDown,
                        searchUrl: _urls2.default.search(),
                        status: statusSummary
                    }),
                    _react2.default.createElement(_resultsPanel2.default, {
                        expanded: panelOpen,
                        focusedIndex: focusedIndex,
                        items: flattenedItems,
                        status: statusSummary,
                        onHide: function onHide() {
                            return _this2._updatePanel(false);
                        }
                    })
                );
            }
        }]);

        return QuickSearch;
    }(_react.PureComponent);

    QuickSearch.propTypes = {
        repository: _propTypes2.default.object,
        project: _propTypes2.default.object
    };
    exports.default = QuickSearch;


    // Visible for testing
    function calculateNextFocusedIndex(items, focusedIndex, reverse) {
        var increment = reverse ? -1 : 1;
        var nextFocusedIndex = focusedIndex;

        while (true) {
            nextFocusedIndex += increment;

            if (nextFocusedIndex < 0 || nextFocusedIndex >= items.length) {
                // we're out of selectable options at the beginning/end of the list
                // leave focus where it was (usually at 0 or length-1)
                return focusedIndex;
            } else if (items[nextFocusedIndex].selectable) {
                // this is the next selectable item!
                return nextFocusedIndex;
            }
        }
    }
});