define('bitbucket-plugin-search/internal/feature/search-common/analytics', ['exports', 'lodash', './search-entities'], function (exports, _lodash, _searchEntities) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.resultType = undefined;
    exports.queryAttributes = queryAttributes;
    exports.entityAttributes = entityAttributes;

    var _lodash2 = _interopRequireDefault(_lodash);

    var _searchEntities2 = _interopRequireDefault(_searchEntities);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var resultType = exports.resultType = {
        CODE: 'code',
        COMMIT: 'commit',
        REPOSITORY: 'repositories' // 'repositories' vs. 'repository' to be consistent with existing analytics events
    };

    function countModifier(query, modifier) {
        var match = query.match(new RegExp(modifier + ':\\S+', 'g'));

        return match && match.length || 0;
    }

    function boolModifier(query, modifier) {
        var match = query.match(new RegExp(modifier + ':\\S+', 'g'));

        if (match && match.length === 1) {
            return match[0].split(':', 2).pop() === 'true';
        }

        return '';
    }

    /**
     * Get a set of analytics attributes from a search query.
     *
     * @param {Object} query - The query to parse attributes from
     * @returns {Object}
     */
    function queryAttributes(query) {
        return {
            'query.length': query.length,
            'term.count': query.split(' ').length,
            'mod.ext': countModifier(query, 'ext'),
            'mod.lang': countModifier(query, 'lang'),
            'mod.path': countModifier(query, 'path'),
            'mod.project': countModifier(query, 'project'),
            'mod.repo': countModifier(query, 'repo'),
            'mod.archived': boolModifier(query, 'archived')
        };
    }

    function entityAttributes(results) {
        var attributes = {};
        _lodash2.default.forEach(_searchEntities2.default, function (entity, entityKey) {
            if (results.hasOwnProperty(entity)) {
                attributes[entity + '.start'] = results[entity].start;
                attributes[entity + '.count'] = results[entity].count;
            }
        });

        return attributes;
    }
});