define('bitbucket-plugin-search/internal/feature/search-common/search-request', ['exports', 'lodash'], function (exports, _lodash) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.searchFor = searchFor;
    exports.nextSearchFor = nextSearchFor;

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    function searchFor(query, requestedEntities, limits) {
        var entities = {};
        (0, _lodash.forEach)(requestedEntities, function (key) {
            entities[key] = {};
        });

        return {
            query: query,
            entities: entities,
            limits: limits
        };
    }

    function nextSearchFor(query, type, limit, previousResult) {
        var entities = _defineProperty({}, type, {
            start: previousResult[type].nextStart,
            limit: limit
        });

        return {
            query: query,
            entities: entities
        };
    }
});