define('bitbucket-plugin-search/internal/feature/search-common/transformer', ['exports', 'lodash', 'bitbucket-plugin-search/internal/component/search-urls'], function (exports, _lodash, _searchUrls) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.transformCodeResult = undefined;

    var _searchUrls2 = _interopRequireDefault(_searchUrls);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _slicedToArray = function () {
        function sliceIterator(arr, i) {
            var _arr = [];
            var _n = true;
            var _d = false;
            var _e = undefined;

            try {
                for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
                    _arr.push(_s.value);

                    if (i && _arr.length === i) break;
                }
            } catch (err) {
                _d = true;
                _e = err;
            } finally {
                try {
                    if (!_n && _i["return"]) _i["return"]();
                } finally {
                    if (_d) throw _e;
                }
            }

            return _arr;
        }

        return function (arr, i) {
            if (Array.isArray(arr)) {
                return arr;
            } else if (Symbol.iterator in Object(arr)) {
                return sliceIterator(arr, i);
            } else {
                throw new TypeError("Invalid attempt to destructure non-iterable instance");
            }
        };
    }();

    var HIGHLIGHT_TAG_REGEX = /<\/?em>/;

    var transformCodeResult = exports.transformCodeResult = function transformCodeResult(value) {
        var fileParts = value.file.split('/');

        value.filename = fileParts.slice(-1);
        value.fileParts = calculateHighlightedFileParts(fileParts, value.pathMatches);

        if (value.hitContexts) {
            // the first line number of the first hitContext
            value.firstLineNumber = (0, _lodash.get)(value, 'hitContexts.0.0', -1);

            // for every hitContext, filter lines with matches, and return the line numbers as a flattened array
            var linesWithMatches = (0, _lodash.flatten)(value.hitContexts.map(function (hitContext) {
                return hitContext.filter(function (line) {
                    return line.line !== 0 && HIGHLIGHT_TAG_REGEX.test(line.text);
                }).map(function (line) {
                    return line.line;
                });
            }));

            var groupedLines = linesWithMatches.reduce(function (_ref, line) {
                var _ref2 = _slicedToArray(_ref, 2),
                    lastLine = _ref2[0],
                    data = _ref2[1];

                if (line === lastLine + 1) {
                    if (Array.isArray(data[data.length - 1])) {
                        data[data.length - 1].push(line);
                    } else {
                        data.pop();
                        data.push([lastLine, line]);
                    }
                } else {
                    data.push(line);
                }

                return [line, data];
            }, [-1, []])[1];

            var lineHash = groupedLines.map(function (item) {
                return Array.isArray(item) ? item[0] + '-' + item[item.length - 1] : item;
            }).join(',');

            value.fileUrl = _searchUrls2.default.fileUrl(value.repository, value.file, lineHash);
        } else {
            value.fileUrl = _searchUrls2.default.fileUrl(value.repository, value.file);
        }

        return value;
    };

    function calculateHighlightedFileParts(fileParts, pathMatches) {
        if (Array.isArray(pathMatches) && pathMatches.length > 0) {
            // This will accumulate a 2D array where each path segment is on the first dimension and
            // all matches within a path segment are in the second dimension
            var segments = [];
            var segment = [];
            pathMatches.forEach(function (match) {
                // Splitting on grouped regexes includes the match in the resulting array as its own element
                match.text.split(/(\/)/g).forEach(function (splitMatch) {
                    if (splitMatch === '/') {
                        segments.push(segment);
                        segment = [];
                    } else if (splitMatch.length !== 0) {
                        // zero length matches are just slashes at the beginning
                        segment.push({
                            part: splitMatch,
                            match: match.match === true
                        });
                    }
                });
            });
            segments.push(segment);

            return segments;
        } else {
            // Just make the current array two dimensional, adding an object so it matches the structure above
            return fileParts.map(function (part) {
                return [{ part: part, match: false }];
            });
        }
    }
});