define('bitbucket-plugin-search/internal/feature/search/internal/search-repositories', ['module', 'exports', '@atlassian/aui', 'classnames', 'jquery', 'lodash', 'prop-types', 'react', 'bitbucket/internal/feature/repository/search-results/search-results-list', '../../search-common/search-entities', '../../search-common/search-request', './analytics', './search'], function (module, exports, _aui, _classnames, _jquery, _lodash, _propTypes, _react, _searchResultsList, _searchEntities, _searchRequest, _analytics, _search) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _classnames2 = _interopRequireDefault(_classnames);

    var _jquery2 = _interopRequireDefault(_jquery);

    var _lodash2 = _interopRequireDefault(_lodash);

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    var _searchResultsList2 = _interopRequireDefault(_searchResultsList);

    var _searchEntities2 = _interopRequireDefault(_searchEntities);

    var _analytics2 = _interopRequireDefault(_analytics);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var LoadMore = function LoadMore(_ref) {
        var onMoreClick = _ref.onMoreClick,
            nextPageSize = _ref.nextPageSize;
        return _react2.default.createElement(
            'button',
            { className: 'load-more-button aui-button aui-button-link', onClick: function onClick() {
                    return onMoreClick();
                } },
            _aui.I18n.getText('bitbucket.search.result.repositories.loadmore', nextPageSize)
        );
    };

    var ResultsTitle = function ResultsTitle(_ref2) {
        var count = _ref2.count;
        return _react2.default.createElement('h4', {
            className: 'results',
            dangerouslySetInnerHTML: {
                __html: _aui.I18n.getText('bitbucket.search.result.repositories.title.html', count)
            }
        });
    };

    var SearchRepositories = function (_Component) {
        _inherits(SearchRepositories, _Component);

        function SearchRepositories() {
            var _ref3;

            var _temp, _this, _ret;

            _classCallCheck(this, SearchRepositories);

            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                args[_key] = arguments[_key];
            }

            return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref3 = SearchRepositories.__proto__ || Object.getPrototypeOf(SearchRepositories)).call.apply(_ref3, [this].concat(args))), _this), _this.state = {
                repositories: [],
                hasContents: false,
                lastResults: null,
                count: 0,
                isLastPage: true
            }, _temp), _possibleConstructorReturn(_this, _ret);
        }

        _createClass(SearchRepositories, [{
            key: 'componentDidMount',
            value: function componentDidMount() {
                var _props = this.props,
                    query = _props.query,
                    limit = _props.limit,
                    active = _props.active;


                if (active) {
                    this.search(query, limit);
                }
            }
        }, {
            key: 'componentDidUpdate',
            value: function componentDidUpdate(_ref4) {
                var prevQuery = _ref4.query;
                var _props2 = this.props,
                    query = _props2.query,
                    limit = _props2.limit,
                    active = _props2.active;


                if (active && query !== prevQuery) {
                    this.search(query, limit);
                }
            }
        }, {
            key: 'search',
            value: function search(query, limit) {
                var _this2 = this;

                return (0, _search.search)((0, _searchRequest.searchFor)(query, [_searchEntities2.default.REPOSITORIES], {
                    primary: limit
                })).then(function (searchResults) {
                    var results = searchResults[_searchEntities2.default.REPOSITORIES];
                    var values = results.values,
                        count = results.count,
                        isLastPage = results.isLastPage;


                    if (values.length > 0) {
                        _this2.setState({
                            repositories: values,
                            hasContents: true,
                            lastResults: searchResults,
                            count: count,
                            isLastPage: isLastPage
                        });
                    } else {
                        _this2.setState({ hasContents: false });
                    }
                }).fail(function (xhr, textError, errorThrown, data) {
                    console.warn('Repository search failed:', _lodash2.default.get(data, 'errors.0.message', 'Unknown reason'));
                });
            }
        }, {
            key: 'searchNext',
            value: function searchNext(query, limit) {
                var _this3 = this;

                var lastResults = this.state.lastResults;


                return (0, _search.search)((0, _searchRequest.nextSearchFor)(query, _searchEntities2.default.REPOSITORIES, limit, lastResults)).then(function (lastResults) {
                    _this3.setState(function (_ref5) {
                        var repositories = _ref5.repositories;

                        var results = lastResults[_searchEntities2.default.REPOSITORIES];
                        var values = results.values,
                            count = results.count,
                            isLastPage = results.isLastPage;


                        return {
                            repositories: repositories.concat(values),
                            hasContents: true,
                            lastResults: lastResults,
                            count: count,
                            isLastPage: isLastPage
                        };
                    });
                }).fail(function (xhr, textError, errorThrown, data) {
                    console.warn('Repository search failed:', _lodash2.default.get(data, 'errors.0.message', 'Unknown reason'));
                });
            }
        }, {
            key: 'render',
            value: function render() {
                var _this4 = this;

                var _props3 = this.props,
                    query = _props3.query,
                    limit = _props3.limit,
                    active = _props3.active;
                var _state = this.state,
                    hasContents = _state.hasContents,
                    repositories = _state.repositories,
                    count = _state.count,
                    isLastPage = _state.isLastPage;

                var title = _react2.default.createElement(ResultsTitle, { count: count });
                var onItemClick = function onItemClick(e) {
                    return _analytics2.default.repositoryResultClicked((0, _jquery2.default)(e.target).closest('li').index());
                };
                var concealed = !(active && hasContents);
                var nextPageSize = Math.min(count - repositories.length, limit);

                return _react2.default.createElement(
                    'div',
                    { className: (0, _classnames2.default)('secondary-results', { concealed: concealed }) },
                    _react2.default.createElement(
                        'section',
                        { className: 'repository-results repository-list-container' },
                        _react2.default.createElement(
                            'h2',
                            null,
                            _aui.I18n.getText('bitbucket.search.summary.repositories')
                        ),
                        _react2.default.createElement(_searchResultsList2.default, {
                            title: title,
                            repositories: repositories,
                            onItemClick: onItemClick
                        }),
                        !isLastPage && _react2.default.createElement(LoadMore, {
                            onMoreClick: function onMoreClick() {
                                _this4.searchNext(query, limit);
                            },
                            nextPageSize: nextPageSize
                        })
                    )
                );
            }
        }]);

        return SearchRepositories;
    }(_react.Component);

    SearchRepositories.propTypes = {
        query: _propTypes2.default.string.isRequired,
        limit: _propTypes2.default.number.isRequired,
        active: _propTypes2.default.bool
    };
    SearchRepositories.defaultProps = {
        active: true
    };
    exports.default = SearchRepositories;
    module.exports = exports['default'];
});