define('bitbucket-plugin-search/internal/feature/search/search', ['module', 'exports', 'jquery', 'lodash', 'bitbucket/internal/bbui/history/history', 'bitbucket/internal/impl/urls', './internal/analytics', './internal/search'], function (module, exports, _jquery, _lodash, _history, _urls, _analytics, _search2) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _jquery2 = _interopRequireDefault(_jquery);

    var _lodash2 = _interopRequireDefault(_lodash);

    var _history2 = _interopRequireDefault(_history);

    var _urls2 = _interopRequireDefault(_urls);

    var _analytics2 = _interopRequireDefault(_analytics);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    var CONTEXT_RE = /(project:\S*)|(repo:\S*)/g;

    function pushNewPageState(query) {
        var url = _urls2.default.search(query);
        _history2.default.pushState({
            query: query
        }, null, url);
    }

    function clearProjectAndRepo(query) {
        query = query.replace(CONTEXT_RE, '');

        return query.trim();
    }

    var Search = function () {
        function Search(el, options) {
            var _this = this;

            _classCallCheck(this, Search);

            var $el = (0, _jquery2.default)(el);

            this.options = _lodash2.default.assign({}, Search.defaultOptions, options);

            this._onPopState = this._onPopState.bind(this);

            $el.html(bitbucketPluginSearch.internal.feature.search.search.emptyState({
                searchUrl: _urls2.default.search(),
                query: this.options.query
            }));

            _history2.default.initialState({
                query: this.options.query
            });

            _history2.default.on('popstate', this._onPopState);

            this.$searchForm = $el.find('.search-form');
            this.$searchResults = $el.find('.search-results');
            this.$query = this.$searchForm.find('input[name=q]');
            this.$searchForm.submit(function (evt) {
                return _this._onSearchSubmit(evt);
            });
            this.$searchQueryAfter = this.$searchForm.find('.search-query-after');
            if (this.options.query && this.options.query.trim() !== '') {
                this._search(this.options.query);
            }

            var $searchResults = $el.find('.search-results');
            $searchResults.on('click', '.code-search-everwhere-link', function () {
                var query = _this.$query.val();
                query = clearProjectAndRepo(query);
                _this._updateQuery(query);
                pushNewPageState(query);
                _analytics2.default.searchEverywhereClicked();
            });
        }

        _createClass(Search, [{
            key: 'destroy',
            value: function destroy() {
                _history2.default.off('popstate', this._onPopState);
            }
        }, {
            key: '_onSearchSubmit',
            value: function _onSearchSubmit(evt) {
                var $query = (0, _jquery2.default)(evt.target).find('input.search-query');
                var query = $query.val().trim();

                this.$searchQueryAfter.empty();

                if (!query) {
                    return false;
                }

                this._search(query);
                pushNewPageState(query);

                return false;
            }
        }, {
            key: '_onPopState',
            value: function _onPopState(evt) {
                var state = evt.state;
                var query = state && state.query || '';
                this._updateQuery(query);
            }
        }, {
            key: '_updateQuery',
            value: function _updateQuery(query) {
                this.$query.val(query);
                this._search(query);
            }
        }, {
            key: '_search',
            value: function _search(query) {
                var _this2 = this;

                if (this._searchResults) {
                    this._searchResults.destroy();
                }

                return (0, _search2.createSearch)(this.$searchResults, query, this.options.limits).then(function (results) {
                    _this2._searchResults = results;

                    _this2.$searchQueryAfter.empty();
                    if (results.options.querySubstituted) {
                        _this2.$searchQueryAfter.html(bitbucketPluginSearch.internal.feature.search.search.querySubstituted());
                    }

                    return results;
                });
            }
        }]);

        return Search;
    }();

    exports.default = Search;


    Search.defaultOptions = {
        limits: {
            primary: 10,
            secondary: 5
        }
    };
    module.exports = exports['default'];
});