define('jira-integration-plugin/jira-create-issue-form-field-helper', ['jquery', 'jira-integration-plugin/lodash'], function ($, _) {
    /**
     * Fill the select options and set selected value if provided.
     * @param {jQuery} $select jQuery reference to the select object
     * @param {Array} data options for the select dropdown
     * @param {String} [selectedValue] id of the selected value
     */
    function fillSelectData ($select, data, selectedValue) {
        var selectHTML = [];
        var selectedOption;
        data.forEach(function (data) {
            var option = {
                value: AJS.escapeHtml(data.id),
                text: data.name,
                iconUrl: data.iconUrl ? data.iconUrl : (data.avatarUrls ? data.avatarUrls['16x16'] : ''),
            };
            if (selectedValue === data.id) {
                option.selected = true;
                selectedOption = data;
            }
            selectHTML.push(aui.form.optionOrOptgroup(option));
        });

        if (selectedOption) {
            selectedOption.text = selectedOption.name;
            $select.html(selectHTML.join(''));
            $select.auiSelect2('data', selectedOption).trigger('change');
        } else {
            selectHTML.unshift(getPlaceholder($select));
            $select.html(selectHTML.join(''));
            $select.auiSelect2('val', '').trigger('change');
        }
    }

    /**
     * Remove all options but the default one from the select and the value to the default.
     * @param {jQuery} $select jQuery reference to the select object
     */
    function resetSelectField ($select) {
        $select.html(getPlaceholder($select));
        $select.auiSelect2('val', '').trigger('change');
    }

    /**
     * Get the default option for the select from the field data.
     * @param {jQuery} $field jQuery reference to the field containing the select
     * @returns {HTML} default option with no value
     */
    function getPlaceholder ($field) {
        var text = $field.attr('data-placeholder');
        return aui.form.optionOrOptgroup({
            value: '',
            text: text,
            iconUrl: '',
        });
    }

    function hideField ($field) {
        $field.parent().hide();
    }

    function showField ($field) {
        $field.parent().show();
    }

    /**
     * Disable or enable the field. Confluence provides enable and disable functions but we can't rely on them to be there.
     * @param {jQuery} $field jQuery reference to the field containing the select
     * @param {Boolean} disabled true to disable the field, false to enable it
     */
    function setFieldDisabled ($field, disabled) {
        disabled ?
        $.fn.disable ? $field.disable() : $field.prop('disabled', true) :
        $.fn.enable ? $field.enable() : $field.prop('disabled', false);
    }

    function setIsLoading ($field, isLoading) {
        return isLoading ? $field.after(aui.icons.icon({icon: 'wait'})) : $field.next('.aui-icon.aui-icon-wait').remove();
    }

    return {
        fillSelectData: fillSelectData,
        resetSelectField: resetSelectField,
        hideField: hideField,
        showField: showField,
        setFieldDisabled: setFieldDisabled,
        setIsLoading: setIsLoading,
    };
});
