const computedStyle = window.getComputedStyle(document.documentElement);
const hasCustomHeaderBgColor = computedStyle.getPropertyValue('--bb-theme-header-bg-color');
const hasCustomPrimaryColor = computedStyle.getPropertyValue('--bb-theme-primary-color');
const isCustomHeaderBgColorDark = computedStyle.getPropertyValue(
    '--bb-theme-header-bg-color-is-dark'
);
const hasCustomLogo = computedStyle.getPropertyValue('--bb-theme-header-logo-image');
const classes = [];

// Add custom theme class to the document element
if (hasCustomHeaderBgColor || hasCustomLogo || hasCustomPrimaryColor) {
    classes.push('look-and-feel-custom-theme');
}

// Add class for custom bg color
if (hasCustomHeaderBgColor) {
    classes.push('theme-header-bg-color');
}

// Add class for dark header color so navigation item text is light
if (isCustomHeaderBgColorDark === 'true') {
    classes.push('theme-header-bg-color-dark');
}

// Add class for custom logo
if (hasCustomLogo) {
    classes.push('theme-custom-logo');
}

// Add class for accent color
if (hasCustomPrimaryColor) {
    classes.push('theme-primary-color');
}

document.documentElement.classList.add(...classes);
