define('bitbucket-plugin-look-and-feel/internal/feature/favicon-picker-dialog', [
    '@atlassian/aui',
    'jquery',
    'bitbucket/internal/widget/avatar-picker-dialog/avatar-picker-dialog',
], function (AJS, $, AvatarPickerDialog) {
    function FaviconPicker(container, options) {
        this.init.apply(this, arguments);
    }

    FaviconPicker.prototype.init = function (container, options) {
        this.$container = $(container);

        var $fieldGroup = this.$container;
        var $faviconPreview = this.$container.find('.favicon-preview img');
        var $faviconInput = this.$container.find('#favicon-upload');
        var $faviconPickerButton = this.$container.find('#favicon-picker-button');

        var FaviconPicker = new AvatarPickerDialog({
            dialogTitle: AJS.I18n.getText('bitbucket.plugin.lookandfeel.favicon.picker.title'),
            maskShape: 'favicon',
            trigger: $faviconPickerButton,
            onCrop: function (croppedDataURI) {
                if ($faviconPreview.length || $fieldGroup.find('.favicon-preview').length) {
                    $fieldGroup.find('.favicon-preview img').attr('src', croppedDataURI);
                } else {
                    $fieldGroup.find('.image-upload-container').before(
                        bitbucket.feature.lookAndFeel.preview({
                            type: 'favicon',
                            src: croppedDataURI,
                        })
                    );
                }
                $faviconInput.val(croppedDataURI);
            },
            xsrfToken: options && options.xsrfToken ? options.xsrfToken : null,
        });
    };

    return FaviconPicker;
});
