define('bitbucket-plugin-look-and-feel/internal/feature/logo-picker-dialog', [
    '@atlassian/aui',
    'jquery',
    'bitbucket/internal/widget/avatar-picker-dialog/avatar-picker-dialog',
], function (AJS, $, AvatarPickerDialog) {
    function LogoPicker(container, options) {
        this.init.apply(this, arguments);
    }

    LogoPicker.prototype.init = function (container, options) {
        this.$container = $(container);

        var $fieldGroup = this.$container;
        var $logoPreview = this.$container.find('.logo-preview img');
        var $logoInput = this.$container.find('#logo-upload');
        var $logoPickerButton = this.$container.find('#logo-picker-button');

        var LogoPicker = new AvatarPickerDialog({
            dialogTitle: AJS.I18n.getText('bitbucket.plugin.lookandfeel.logo.picker.title'),
            maskShape: 'logo-rectangle',
            trigger: $logoPickerButton,
            onCrop: function (croppedDataURI) {
                if ($logoPreview.length || $fieldGroup.find('.logo-preview').length) {
                    $fieldGroup.find('.logo-preview img').attr('src', croppedDataURI);
                } else {
                    $fieldGroup.find('.image-upload-container').before(
                        bitbucket.feature.lookAndFeel.preview({
                            type: 'logo',
                            src: croppedDataURI,
                        })
                    );
                }
                $fieldGroup.find('.description').after(
                    aui.message.warning({
                        content: AJS.I18n.getText(
                            'bitbucket.plugin.lookandfeel.header.logo.image.warning'
                        ),
                    })
                );
                $logoInput.val(croppedDataURI);
            },
            xsrfToken: options && options.xsrfToken ? options.xsrfToken : null,
        });
    };

    return LogoPicker;
});
