define('bitbucket-plugin-look-and-feel/internal/feature/settings', [
    '@atlassian/aui',
    'jquery',
    'bitbucket-plugin-look-and-feel/internal/feature/favicon-picker-dialog',
    'bitbucket-plugin-look-and-feel/internal/feature/logo-picker-dialog',
    'bitbucket/internal/widget/client-file-handlers/client-file-reader',
], function (AJS, $, FaviconPickerDialog, LogoPickerDialog, ClientFileReader) {
    return {
        onReady: function () {
            var adg3ColourPalette = [
                ['#0747A6', '#0052CC', '#0065FF', '#2684FF', '#4C9AFF'], // B500, B400, B300, B200, B100
                ['#008DA6', '#00A3BF', '#00B8D9', '#00C7E6', '#79E2F2'], // T500, T400, T300, T200, T100,
                ['#403294', '#5243AA', '#6554C0', '#8777D9', '#998DD9'], // P500, P400, P300, P200, P100,
                ['#BF2600', '#DE350B', '#FF5630', '#FF7452', '#FF8F73'], // R500, R400, R300, R200, R100
                ['#FF8B00', '#FF991F', '#FFAB00', '#FFC400', '#FFE380'], // Y500, Y400, Y300, Y200, Y100
                ['#006644', '#00875A', '#36B37E', '#57D9A3', '#79F2C0'], // G500, G400, G300, G200, G100
                ['#091E42', '#172B4D', '#253858', '#344563', '#42526E'], // N900, N800, N700, N600, N500
                ['#505F79', '#5E6C84', '#6B778C', '#7A869A', '#FFFFFF'], // N400, N300, N200, N100, N0
            ];

            var colourPickerSettings = {
                showInput: true,
                preferredFormat: 'hex6',
                showButtons: false,
                className: 'bitbucket-plugin-look-and-feel-color-picker',
                showPalette: true,
                palette: adg3ColourPalette,
            };

            $('#primary-colour').spectrum(colourPickerSettings);
            $('#header-colour').spectrum(colourPickerSettings);

            if (ClientFileReader.isSupported()) {
                var xsrfToken = $(
                    '.bitbucket-plugin-look-and-feel-form input[name=atl_token]'
                ).val();

                new LogoPickerDialog('.logo-picker-field', {
                    xsrfToken: {
                        name: 'atl_token',
                        value: xsrfToken,
                    },
                });

                new FaviconPickerDialog('.favicon-picker-field', {
                    xsrfToken: {
                        name: 'atl_token',
                        value: xsrfToken,
                    },
                });
            } else {
                $('#logo-picker-button').attr('aria-disabled', 'true').prop('disabled', true);
                $('.bitbucket-plugin-look-and-feel-form').prepend(
                    aui.message.warning({
                        content: AJS.I18n.getText(
                            'bitbucket.plugin.lookandfeel.logo.picker.browser.warning'
                        ),
                    })
                );
            }
        },
    };
});

document.addEventListener('DOMContentLoaded', function () {
    require('bitbucket-plugin-look-and-feel/internal/feature/settings').onReady();
});
