var APPSWITCHER_TRIGGER_CLICK = "appswitcher.trigger.click";
var APPSWITCHER_DROPDOWN_SHOW = "appswitcher.dropdown.show";
var APPSWITCHER_DROPDOWN_DISPLAY_ERROR = "appswitcher.dropdown.display.error";
var APPSWITCHER_APP_LINK_CLICK = "appswitcher.app.link.click";
var APPSWITCHER_CONFIGURE_LINK_CLICK = "appswitcher.configure.link.click";

(function ($, NL) {
    var USER_ADMIN_KEY = 'isUserAdmin';
    var SWITCHER_SELECTOR = '#app-switcher';

    /**
     * @typedef {"bamboo"|"confluence"|"crowd"|"fecru"|"jira"|"refapp"|"stash"} AppType
     */

    /**
     * @typedef {Object} AppLink
     * @property {AppType} applicationType
     * @property {String} key
     * @property {String} label
     * @property {String} link - url to the instance
     * @property {boolean} local
     * @property {boolean} self - true if this instance, false otherwise
     * @example
     * ```
     * {
     *   applicationType: "stash",
     *   key: "home",
     *   label: "Bitbucket",
     *   link: "http://localhost:7990/bitbucket/",
     *   local: false,
     *   self: true
     * }
     * ```
     */

    /**
     * @param {Object} options
     * @constructor
     */
    NL.AppSwitcher = function (options) {
        var ADMIN_EDIT_PATH = AJS.contextPath() + "/plugins/servlet/customize-application-navigator";
        var that = this;
        this.$dropdown = null;

        options = $.extend({
            dropdownContents: null
        }, options);

        this.getLinks = function () {
            return $.ajax({
                url: AJS.contextPath() + '/rest/menu/latest/appswitcher',
                cache: false,
                dataType: 'json'
            }).done(this.updateDropdown).fail(this.showError);
        };

        this.getDropdown = function () {
            if (!this.$dropdown) {
                this.$dropdown = $(options.dropdownContents);
                this.isUserAdmin = this.$dropdown.data('is-user-admin');
            }
            return this.$dropdown;
        };

        /**
         * @param {AppLink[]} data
         */
        this.updateDropdown = function (data) {
            $(function () {
                that.getDropdown().html(navlinks.templates.appswitcher_old.applications({
                    apps: data,
                    showAdminLink: that.isUserAdmin,
                    adminLink: ADMIN_EDIT_PATH
                }));

                that.bindAnalyticsHandlers();
            });
        };

        this.bindAnalyticsHandlers = function () {
            $(".app-switcher-trigger").on("click", function () {
                AJS.trigger("analyticsEvent", {name: APPSWITCHER_TRIGGER_CLICK});
            });

            $("#app-switcher").on("aui-dropdown2-show", function () {
                AJS.trigger("analyticsEvent", {name: APPSWITCHER_DROPDOWN_SHOW});
            });

            $('#app-switcher .nav-link').on('click', function () {
                var product = "custom";
                var productLink = $(this).find("a");
                var url = productLink.attr("href");
                var hostname = window.location.hostname;

                if (url && url.indexOf("bitbucket.org") > -1) {
                    product = "bitbucket-cloud";
                } else if (url.indexOf(hostname + "/wiki") > -1) {
                    product = "confluence";
                } else if (url.indexOf(hostname + "/build") > -1) {
                    product = "bamboo";
                } else if (url.indexOf(hostname) > -1) {
                    product = "jira";
                }

                AJS.trigger("analyticsEvent", {
                    name: APPSWITCHER_APP_LINK_CLICK,
                    data: {product: product}
                });
            });

            $('.nav-link-edit-wrapper').on('click', function () {
                AJS.trigger("analyticsEvent", {name: APPSWITCHER_CONFIGURE_LINK_CLICK});
            })
        };

        this.showError = function () {
            $(function () {
                AJS.trigger("analyticsEvent", {name: APPSWITCHER_DROPDOWN_DISPLAY_ERROR});
                that.getDropdown()
                    .html(navlinks.templates.appswitcher_old.error())
                    .off('.appswitcher')
                    .on('click.appswitcher', '.app-switcher-retry', that.retryLoading.bind(that));
            });
        };

        this.retryLoading = function (e) {
            this.getDropdown().html(navlinks.templates.appswitcher_old.loading());
            this.getLinks();
            e && e.stopPropagation();
        };

        this.getLinks();
    };

    $(function () {
        if ($(SWITCHER_SELECTOR).data('is-switcher') === true) {
            new NL.AppSwitcher({
                dropdownContents: SWITCHER_SELECTOR
            });
        }
    })
}(jQuery, window.NL = (window.NL || {})));
