define('bitbucket-plugin-audit/internal/notification/audit-retention-config-review-notification', [
    'bitbucket/internal/util/analytics',
    'bitbucket/internal/util/events',
    'bitbucket/util/navbuilder',
    'bitbucket/util/server',
    'exports',
], function (analytics, events, nav, server, exports) {
    exports.dismiss = function () {
        analytics.add('stash.client.alerts.audit.retention.review.dismissed');

        return server.rest({
            url: nav
                .rest('audit')
                .addPathComponents('notification-settings', 'retention-config-review')
                .build(),
            statusCode: {
                '*': false,
            },
            type: 'DELETE',
        });
    };
    exports.review = function () {
        analytics.add('stash.client.alerts.audit.retention.review.actioned');
    };

    events.on('bitbucket.internal.DO_NOT_USE.ui.alerts.dialog.opened', function (alerts) {
        var auditRetentionAlertPredicate = function (alert) {
            return alert['alertType'] === 'bitbucket.web.audit.retention.config.review';
        };

        if (Object.values(alerts).some(auditRetentionAlertPredicate)) {
            analytics.add('stash.client.alerts.audit.retention.review.opened');
        }
    });
});
