define('bitbucket-plugin-build/internal/feature/build/branch-list/build-status-branch-list', ['jquery', 'bitbucket/internal/util/events', 'bitbucket/util/navbuilder', 'bitbucket/util/state', '../common/build-status-common'], function (_jquery, _events, _navbuilder, _state, _buildStatusCommon) {
    'use strict';

    var _jquery2 = _interopRequireDefault(_jquery);

    var _events2 = _interopRequireDefault(_events);

    var navbuilder = _interopRequireWildcard(_navbuilder);

    var _state2 = _interopRequireDefault(_state);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var buildColumn = '.build-status-branch-list-col';
    var buildColumnHeader = '.branch-table #build-status-branch-list-col';
    var buildIcon = '.build-icon';
    var branchKey = 'data-id';

    function showSummary(statsByBranch, $rows) {
        var showBuildsColumn = false;

        $rows.each(function () {
            var $row = (0, _jquery2.default)(this);
            var $buildColumn = $row.find(buildColumn);
            var branch = $row.attr(branchKey);
            var stats = statsByBranch[branch];

            if (stats) {
                var link = navbuilder.repository(_state2.default.getRepository()).builds().withParams({ at: branch }).build();

                $buildColumn.html(bitbucketPluginBuild.internal.feature.build.common.buildStatusCommon.summaryIcon({
                    buildRefId: branch,
                    stats: stats,
                    link: link
                })).find(buildIcon).tooltip({
                    gravity: 'ne',
                    html: false
                });
                showBuildsColumn = true;
            }
        });

        (0, _jquery2.default)(buildColumnHeader).toggle(showBuildsColumn);
        (0, _jquery2.default)(buildColumn).toggle(showBuildsColumn);
    }

    function extractBranchRefs($rows) {
        var result = $rows.map(function (row, el) {
            return el.getAttribute(branchKey);
        }).toArray();

        return result;
    }

    var columnRenderer = new _buildStatusCommon.BuildStatusColumnRenderer(buildColumnHeader, buildColumn);

    _events2.default.on('bitbucket.internal.DO_NOT_USE.widget.pagedscrollable.dataLoaded', function (start, limit, data) {
        var $rows = (0, _jquery2.default)('.branch-row').slice(start, start + data.size);

        var getStats = function getStats(refs) {
            return (0, _buildStatusCommon.getStatsByRefsAndRepo)(refs, _state2.default.getRepository());
        };

        extractBranchRefs($rows).map(function (branch) {
            columnRenderer.populateBuildStatusLater(branch, getStats, function ($header, cellSelector, statsByBranch) {
                showSummary(statsByBranch, $rows);
            });
        });
    });
});