define('bitbucket-plugin-build/internal/feature/build/commit-list/build-status-commit-list', ['jquery', 'bitbucket/internal/model/page-state', 'bitbucket/internal/util/events', 'bitbucket/util/navbuilder', 'bitbucket/util/state', '../common/build-status-common'], function (_jquery, _pageState, _events, _navbuilder, _state, _buildStatusCommon) {
    'use strict';

    var _jquery2 = _interopRequireDefault(_jquery);

    var _pageState2 = _interopRequireDefault(_pageState);

    var _events2 = _interopRequireDefault(_events);

    var navbuilder = _interopRequireWildcard(_navbuilder);

    var _state2 = _interopRequireDefault(_state);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var buildColumn = '.build-status-commit-list-col';
    var buildColumnHeader = '.commits-table thead .build-status-commit-list-col';
    var buildIcon = '.build-icon';
    var commitIdKey = 'commitid';

    function showSummary(statsByCommitId, $rows) {
        var showColumnHeader = false;
        $rows.each(function () {
            var $row = (0, _jquery2.default)(this);
            var $buildColumn = $row.find(buildColumn);
            var commitId = $row.data(commitIdKey);
            var stats = statsByCommitId[commitId];

            if (stats) {
                var link = navbuilder.repository(_state2.default.getRepository()).builds().withParams({ at: commitId }).build();

                $buildColumn.html(bitbucketPluginBuild.internal.feature.build.common.buildStatusCommon.summaryIcon({
                    commitId: commitId,
                    stats: stats,
                    link: link
                })).find(buildIcon).tooltip({
                    gravity: 'ne',
                    html: false
                });
                showColumnHeader = true;
            }
        });

        if (showColumnHeader) {
            (0, _jquery2.default)(buildColumnHeader).show();
        }
    }

    function extractCommitIds($rows) {
        return $rows.map(function () {
            return (0, _jquery2.default)(this).data(commitIdKey);
        }).toArray();
    }

    var columnRenderer = new _buildStatusCommon.BuildStatusColumnRenderer(buildColumnHeader, buildColumn);

    _events2.default.on('bitbucket.internal.DO_NOT_USE.widget.commitsTable.contentAdded', function (page) {
        if (!_pageState2.default.getCurrentUser()) {
            return;
        }

        var $rows = page.values;

        extractCommitIds($rows).map(function (commitId) {
            columnRenderer.populateBuildStatusLater(commitId, _buildStatusCommon.getStatsByCommitIdsAndRepo, function ($header, cellSelector, statsByCommitId) {
                showSummary(statsByCommitId, $rows);
            });
        });
    });
});