define('bitbucket-plugin-build/internal/feature/build/common/build-status-common', ['exports', 'jquery', 'lodash', 'bitbucket/internal/util/ajax', 'bitbucket/util/navbuilder', 'bitbucket/util/server', 'bitbucket/util/state'], function (exports, _jquery, _lodash, _ajax, _navbuilder, _server, _state) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.getQueryParam = exports.getStatsByRefsAndRepo = exports.getStatsByCommitIdsAndRepo = exports.getStatsByPRsAndRepo = exports.queryBuildStatusAndDecorate = exports.BuildStatusColumnRenderer = undefined;

    var _jquery2 = _interopRequireDefault(_jquery);

    var ajax = _interopRequireWildcard(_ajax);

    var navbuilder = _interopRequireWildcard(_navbuilder);

    var server = _interopRequireWildcard(_server);

    var _state2 = _interopRequireDefault(_state);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _slicedToArray = function () {
        function sliceIterator(arr, i) {
            var _arr = [];
            var _n = true;
            var _d = false;
            var _e = undefined;

            try {
                for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
                    _arr.push(_s.value);

                    if (i && _arr.length === i) break;
                }
            } catch (err) {
                _d = true;
                _e = err;
            } finally {
                try {
                    if (!_n && _i["return"]) _i["return"]();
                } finally {
                    if (_d) throw _e;
                }
            }

            return _arr;
        }

        return function (arr, i) {
            if (Array.isArray(arr)) {
                return arr;
            } else if (Symbol.iterator in Object(arr)) {
                return sliceIterator(arr, i);
            } else {
                throw new TypeError("Invalid attempt to destructure non-iterable instance");
            }
        };
    }();

    var hasBuildStatus = false;

    // cache by build ref ID to allow incremental updating of build status.
    // for instance if a plugin point with a build status is updated for a given commit
    // and we know what that commit is, we can use this cache to continue displaying the
    // build status rather than rendering an empty placeholder and rendering a new icon.
    var buildStatsCache = {};

    function decorate(decorationProvider, $placeholder, buildRefId, link, stats, onShow) {
        if (stats && (stats.failed || stats.inProgress || stats.successful || stats.cancelled || stats.unknown)) {
            $placeholder.replaceWith(decorationProvider({
                buildRefId: buildRefId,
                link: link,
                stats: stats
            }));

            if ((0, _lodash.isFunction)(onShow)) {
                onShow($placeholder);
            }

            return true;
        }

        // Remove this element so that first-child/last-child selectors fire
        $placeholder.remove();

        return false;
    }

    function getStats(params) {
        var repository = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;

        var url = navbuilder.rest('ui');

        url = url.repository(repository || _state2.default.getRepository()).addPathComponents('build-summaries').withDefinedParams(params).build();

        return server.rest({
            url: url,
            statusCode: {
                '*': false // ignore any error and do not fill the build status column in that case
            }
        });
    }

    /**
     * Get build summary stats for commit IDs, scoped to the current repository.
     * @param {string[]} commitIds - List of commit ids to search stats for.
     * @param {Object} [repository] - Optional repository to scope the request to. Defaults to the current repo.
     * @returns {jqXHR}
     */
    function getStatsByCommitIdsAndRepo(commitIds) {
        var repository = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;

        return getStats({ commitId: commitIds }, repository);
    }

    /**
     * Get build summary stats for refs, scoped to a repository
     * @param {string[]} refs - List of refs to search stats for.
     * @param {Object} repository - The repository to scope the request to.
     * @returns {jqXHR}
     */
    function getStatsByRefsAndRepo(refs, repository) {
        return getStats({ ref: refs }, repository);
    }

    /**
     * Get build summary stats for PR IDs, scope to a repo
     * @param {string[]} prIds - List of commit ids to search stats for.
     * @param {Object} repository - The repository to scope the request to.
     * @returns {jqXHR}
     */
    function getStatsByPRsAndRepo(prIds, repository) {
        return getStats({ pullRequestId: prIds }, repository);
    }

    function cellDecorator(ctx) {
        return (0, _jquery2.default)(bitbucketPluginBuild.internal.feature.build.common.buildStatusCommon.summaryIcon(ctx)).tooltip({
            gravity: 'ne',
            html: false
        });
    }

    function replacePlaceholders($header, cellSelector, statsByBuildRefIds) {
        var $placeholders = (0, _jquery2.default)(cellSelector + ' .build-status-placeholder');
        var anyStats = Array.prototype.reduce.call($placeholders, function (anyStats, placeholderEl) {
            var $placeholder = (0, _jquery2.default)(placeholderEl);
            var buildRefId = $placeholder.attr('data-build-ref-id');
            var link = $placeholder.attr('data-link') || $placeholder.attr('href');
            var cellHadStats = decorate(cellDecorator, $placeholder, buildRefId, link, statsByBuildRefIds[buildRefId]);

            return anyStats || cellHadStats;
        }, false);

        if (anyStats) {
            $header.show();
        }
    }

    function BuildStatusColumnRenderer(headerSelector, cellSelector) {
        this._populateTimeout = null;
        this._pendingBuildRefIds = [];
        this._headerSelector = headerSelector;
        this._cellSelector = cellSelector;
    }

    BuildStatusColumnRenderer.prototype.renderPlaceholder = function (buildRefId, getStats, link, date) {
        var useIndividualRequests = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : false;

        this.populateBuildStatusLater(buildRefId, getStats, replacePlaceholders, useIndividualRequests);
        // if there is a reference to the current commit already, use the existing build icon as the placeholder
        if (buildStatsCache.hasOwnProperty(buildRefId)) {
            return bitbucketPluginBuild.internal.feature.build.common.buildStatusCommon.summaryIcon({
                buildRefId: buildRefId,
                link: link,
                stats: buildStatsCache[buildRefId],
                isPlaceholder: true,
                date: date
            });
        }

        return bitbucketPluginBuild.internal.feature.build.common.buildStatusCommon.placeholder({
            buildRefId: buildRefId,
            link: link,
            date: date
        });
    };

    BuildStatusColumnRenderer.prototype.populateBuildStatusLater = function (buildRefId, getStats, populateCells) {
        var _this = this;

        var useIndividualRequests = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;

        var self = this;

        if (useIndividualRequests) {
            if (this._populateTimeout) {
                clearTimeout(this._populateTimeout);
            }
            getStats([buildRefId]).then(fillCache).done(function (cache) {
                _this._populateTimeout = setTimeout(function () {
                    populateCells((0, _jquery2.default)(self._headerSelector), self._cellSelector, cache);
                }, 50); // this is delayed to allow population of pending build ref id's
            });

            return;
        }

        if (!this._pendingBuildRefIds.length) {
            this._queuePopulation(populateCells, getStats);
        }

        this._pendingBuildRefIds.push(buildRefId);
    };

    BuildStatusColumnRenderer.prototype._queuePopulation = function (populateCells, getStats) {
        var self = this;
        setTimeout(function () {
            var buildRefIds = self._pendingBuildRefIds;
            self._pendingBuildRefIds = [];
            getStats(buildRefIds).then(fillCache).done(populateCells.bind(null, (0, _jquery2.default)(self._headerSelector), self._cellSelector));
        }, 50); // this is delayed to allow population of pending build ref id's
    };

    function fillCache(stats) {
        Object.entries(stats).map(function (_ref) {
            var _ref2 = _slicedToArray(_ref, 2),
                key = _ref2[0],
                value = _ref2[1];

            buildStatsCache[key] = value;
        });

        return buildStatsCache;
    }

    function queryBuildStatusAndDecorate(buildRefId, getStats, placeholderSelector, decorationProvider, onShow) {
        var link = navbuilder.repository(_state2.default.getRepository()).builds().withParams({ at: buildRefId }).build();

        getStats(buildRefId).done(function (stats) {
            var $placeholder = (0, _jquery2.default)(placeholderSelector);
            var cellHadStats = decorate(decorationProvider, $placeholder, buildRefId, link, stats[buildRefId], function () {
                if (onShow) {
                    onShow($placeholder);
                }
            });
            hasBuildStatus = hasBuildStatus || cellHadStats;
        });
    }

    var getQueryParam = function getQueryParam(name) {
        return navbuilder.parseQuery(window.location.search).getParamValue(name);
    };

    exports.BuildStatusColumnRenderer = BuildStatusColumnRenderer;
    exports.queryBuildStatusAndDecorate = queryBuildStatusAndDecorate;
    exports.getStatsByPRsAndRepo = getStatsByPRsAndRepo;
    exports.getStatsByCommitIdsAndRepo = getStatsByCommitIdsAndRepo;
    exports.getStatsByRefsAndRepo = getStatsByRefsAndRepo;
    exports.getQueryParam = getQueryParam;
});